// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The CassandraDataCenterSeedNode.
/// </summary>
public partial class CassandraDataCenterSeedNode : ProvisionableConstruct
{
    /// <summary>
    /// IP address of this seed node.
    /// </summary>
    public BicepValue<string> IPAddress 
    {
        get { Initialize(); return _iPAddress!; }
        set { Initialize(); _iPAddress!.Assign(value); }
    }
    private BicepValue<string>? _iPAddress;

    /// <summary>
    /// Creates a new CassandraDataCenterSeedNode.
    /// </summary>
    public CassandraDataCenterSeedNode()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CassandraDataCenterSeedNode.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _iPAddress = DefineProperty<string>("IPAddress", ["ipAddress"]);
    }
}
