// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Properties of a managed Cassandra data center.
/// </summary>
public partial class CassandraDataCenterProperties : ProvisionableConstruct
{
    /// <summary>
    /// The status of the resource at the time the operation was called.
    /// </summary>
    public BicepValue<CassandraProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
        set { Initialize(); _provisioningState!.Assign(value); }
    }
    private BicepValue<CassandraProvisioningState>? _provisioningState;

    /// <summary>
    /// The region this data center should be created in.
    /// </summary>
    public BicepValue<AzureLocation> DataCenterLocation 
    {
        get { Initialize(); return _dataCenterLocation!; }
        set { Initialize(); _dataCenterLocation!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _dataCenterLocation;

    /// <summary>
    /// Resource id of a subnet the nodes in this data center should have their
    /// network interfaces connected to. The subnet must be in the same region
    /// specified in &apos;dataCenterLocation&apos; and must be able to route
    /// to the subnet specified in the cluster&apos;s
    /// &apos;delegatedManagementSubnetId&apos; property. This resource id
    /// will be of the form &apos;/subscriptions/&lt;subscription
    /// id&gt;/resourceGroups/&lt;resource
    /// group&gt;/providers/Microsoft.Network/virtualNetworks/&lt;virtual
    /// network&gt;/subnets/&lt;subnet&gt;&apos;.
    /// </summary>
    public BicepValue<ResourceIdentifier> DelegatedSubnetId 
    {
        get { Initialize(); return _delegatedSubnetId!; }
        set { Initialize(); _delegatedSubnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _delegatedSubnetId;

    /// <summary>
    /// The number of nodes the data center should have. This is the desired
    /// number. After it is set, it may take some time for the data center to
    /// be scaled to match. To monitor the number of nodes and their status,
    /// use the fetchNodeStatus method on the cluster.
    /// </summary>
    public BicepValue<int> NodeCount 
    {
        get { Initialize(); return _nodeCount!; }
        set { Initialize(); _nodeCount!.Assign(value); }
    }
    private BicepValue<int>? _nodeCount;

    /// <summary>
    /// IP addresses for seed nodes in this data center. This is for reference.
    /// Generally you will want to use the seedNodes property on the cluster,
    /// which aggregates the seed nodes from all data centers in the cluster.
    /// </summary>
    public BicepList<CassandraDataCenterSeedNode> SeedNodes 
    {
        get { Initialize(); return _seedNodes!; }
    }
    private BicepList<CassandraDataCenterSeedNode>? _seedNodes;

    /// <summary>
    /// A fragment of a cassandra.yaml configuration file to be included in the
    /// cassandra.yaml for all nodes in this data center. The fragment should
    /// be Base64 encoded, and only a subset of keys are allowed.
    /// </summary>
    public BicepValue<string> Base64EncodedCassandraYamlFragment 
    {
        get { Initialize(); return _base64EncodedCassandraYamlFragment!; }
        set { Initialize(); _base64EncodedCassandraYamlFragment!.Assign(value); }
    }
    private BicepValue<string>? _base64EncodedCassandraYamlFragment;

    /// <summary>
    /// Key uri to use for encryption of managed disks. Ensure the system
    /// assigned identity of the cluster has been assigned appropriate
    /// permissions(key get/wrap/unwrap permissions) on the key.
    /// </summary>
    public BicepValue<Uri> ManagedDiskCustomerKeyUri 
    {
        get { Initialize(); return _managedDiskCustomerKeyUri!; }
        set { Initialize(); _managedDiskCustomerKeyUri!.Assign(value); }
    }
    private BicepValue<Uri>? _managedDiskCustomerKeyUri;

    /// <summary>
    /// Indicates the Key Uri of the customer key to use for encryption of the
    /// backup storage account.
    /// </summary>
    public BicepValue<Uri> BackupStorageCustomerKeyUri 
    {
        get { Initialize(); return _backupStorageCustomerKeyUri!; }
        set { Initialize(); _backupStorageCustomerKeyUri!.Assign(value); }
    }
    private BicepValue<Uri>? _backupStorageCustomerKeyUri;

    /// <summary>
    /// Virtual Machine SKU used for data centers. Default value is
    /// Standard_DS14_v2.
    /// </summary>
    public BicepValue<string> Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); _sku!.Assign(value); }
    }
    private BicepValue<string>? _sku;

    /// <summary>
    /// Disk SKU used for data centers. Default value is P30.
    /// </summary>
    public BicepValue<string> DiskSku 
    {
        get { Initialize(); return _diskSku!; }
        set { Initialize(); _diskSku!.Assign(value); }
    }
    private BicepValue<string>? _diskSku;

    /// <summary>
    /// Number of disks attached to each node. Default is 4.
    /// </summary>
    public BicepValue<int> DiskCapacity 
    {
        get { Initialize(); return _diskCapacity!; }
        set { Initialize(); _diskCapacity!.Assign(value); }
    }
    private BicepValue<int>? _diskCapacity;

    /// <summary>
    /// If the data center has Availability Zone support, apply it to the
    /// Virtual Machine ScaleSet that host the cassandra data center virtual
    /// machines.
    /// </summary>
    public BicepValue<bool> DoesSupportAvailabilityZone 
    {
        get { Initialize(); return _doesSupportAvailabilityZone!; }
        set { Initialize(); _doesSupportAvailabilityZone!.Assign(value); }
    }
    private BicepValue<bool>? _doesSupportAvailabilityZone;

    /// <summary>
    /// Ldap authentication method properties. This feature is in preview.
    /// </summary>
    public AuthenticationMethodLdapProperties AuthenticationMethodLdapProperties 
    {
        get { Initialize(); return _authenticationMethodLdapProperties!; }
        set { Initialize(); AssignOrReplace(ref _authenticationMethodLdapProperties, value); }
    }
    private AuthenticationMethodLdapProperties? _authenticationMethodLdapProperties;

    /// <summary>
    /// Whether the data center has been deallocated.
    /// </summary>
    public BicepValue<bool> Deallocated 
    {
        get { Initialize(); return _deallocated!; }
        set { Initialize(); _deallocated!.Assign(value); }
    }
    private BicepValue<bool>? _deallocated;

    /// <summary>
    /// Error related to resource provisioning.
    /// </summary>
    public CassandraError ProvisionError 
    {
        get { Initialize(); return _provisionError!; }
        set { Initialize(); AssignOrReplace(ref _provisionError, value); }
    }
    private CassandraError? _provisionError;

    /// <summary>
    /// Ip of the VPN Endpoint for this data center.
    /// </summary>
    public BicepValue<string> PrivateEndpointIPAddress 
    {
        get { Initialize(); return _privateEndpointIPAddress!; }
        set { Initialize(); _privateEndpointIPAddress!.Assign(value); }
    }
    private BicepValue<string>? _privateEndpointIPAddress;

    /// <summary>
    /// Creates a new CassandraDataCenterProperties.
    /// </summary>
    public CassandraDataCenterProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CassandraDataCenterProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _provisioningState = DefineProperty<CassandraProvisioningState>("ProvisioningState", ["provisioningState"]);
        _dataCenterLocation = DefineProperty<AzureLocation>("DataCenterLocation", ["dataCenterLocation"]);
        _delegatedSubnetId = DefineProperty<ResourceIdentifier>("DelegatedSubnetId", ["delegatedSubnetId"]);
        _nodeCount = DefineProperty<int>("NodeCount", ["nodeCount"]);
        _seedNodes = DefineListProperty<CassandraDataCenterSeedNode>("SeedNodes", ["seedNodes"], isOutput: true);
        _base64EncodedCassandraYamlFragment = DefineProperty<string>("Base64EncodedCassandraYamlFragment", ["base64EncodedCassandraYamlFragment"]);
        _managedDiskCustomerKeyUri = DefineProperty<Uri>("ManagedDiskCustomerKeyUri", ["managedDiskCustomerKeyUri"]);
        _backupStorageCustomerKeyUri = DefineProperty<Uri>("BackupStorageCustomerKeyUri", ["backupStorageCustomerKeyUri"]);
        _sku = DefineProperty<string>("Sku", ["sku"]);
        _diskSku = DefineProperty<string>("DiskSku", ["diskSku"]);
        _diskCapacity = DefineProperty<int>("DiskCapacity", ["diskCapacity"]);
        _doesSupportAvailabilityZone = DefineProperty<bool>("DoesSupportAvailabilityZone", ["availabilityZone"]);
        _authenticationMethodLdapProperties = DefineModelProperty<AuthenticationMethodLdapProperties>("AuthenticationMethodLdapProperties", ["authenticationMethodLdapProperties"]);
        _deallocated = DefineProperty<bool>("Deallocated", ["deallocated"]);
        _provisionError = DefineModelProperty<CassandraError>("ProvisionError", ["provisionError"]);
        _privateEndpointIPAddress = DefineProperty<string>("PrivateEndpointIPAddress", ["privateEndpointIpAddress"]);
    }
}
