// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB Cassandra table column.
/// </summary>
public partial class CassandraColumn : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB Cassandra table column.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Type of the Cosmos DB Cassandra table column.
    /// </summary>
    public BicepValue<string> CassandraColumnType 
    {
        get { Initialize(); return _cassandraColumnType!; }
        set { Initialize(); _cassandraColumnType!.Assign(value); }
    }
    private BicepValue<string>? _cassandraColumnType;

    /// <summary>
    /// Creates a new CassandraColumn.
    /// </summary>
    public CassandraColumn()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CassandraColumn.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _cassandraColumnType = DefineProperty<string>("CassandraColumnType", ["type"]);
    }
}
