// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Properties of a managed Cassandra cluster.
/// </summary>
public partial class CassandraClusterProperties : ProvisionableConstruct
{
    /// <summary>
    /// The status of the resource at the time the operation was called.
    /// </summary>
    public BicepValue<CassandraProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
        set { Initialize(); _provisioningState!.Assign(value); }
    }
    private BicepValue<CassandraProvisioningState>? _provisioningState;

    /// <summary>
    /// To create an empty cluster, omit this field or set it to null. To
    /// restore a backup into a new cluster, set this field to the resource id
    /// of the backup.
    /// </summary>
    public BicepValue<string> RestoreFromBackupId 
    {
        get { Initialize(); return _restoreFromBackupId!; }
        set { Initialize(); _restoreFromBackupId!.Assign(value); }
    }
    private BicepValue<string>? _restoreFromBackupId;

    /// <summary>
    /// Resource id of a subnet that this cluster&apos;s management service
    /// should have its network interface attached to. The subnet must be
    /// routable to all subnets that will be delegated to data centers. The
    /// resource id must be of the form &apos;/subscriptions/&lt;subscription
    /// id&gt;/resourceGroups/&lt;resource
    /// group&gt;/providers/Microsoft.Network/virtualNetworks/&lt;virtual
    /// network&gt;/subnets/&lt;subnet&gt;&apos;.
    /// </summary>
    public BicepValue<ResourceIdentifier> DelegatedManagementSubnetId 
    {
        get { Initialize(); return _delegatedManagementSubnetId!; }
        set { Initialize(); _delegatedManagementSubnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _delegatedManagementSubnetId;

    /// <summary>
    /// Which version of Cassandra should this cluster converge to running
    /// (e.g., 3.11). When updated, the cluster may take some time to migrate
    /// to the new version.
    /// </summary>
    public BicepValue<string> CassandraVersion 
    {
        get { Initialize(); return _cassandraVersion!; }
        set { Initialize(); _cassandraVersion!.Assign(value); }
    }
    private BicepValue<string>? _cassandraVersion;

    /// <summary>
    /// If you need to set the clusterName property in cassandra.yaml to
    /// something besides the resource name of the cluster, set the value to
    /// use on this property.
    /// </summary>
    public BicepValue<string> ClusterNameOverride 
    {
        get { Initialize(); return _clusterNameOverride!; }
        set { Initialize(); _clusterNameOverride!.Assign(value); }
    }
    private BicepValue<string>? _clusterNameOverride;

    /// <summary>
    /// Which authentication method Cassandra should use to authenticate
    /// clients. &apos;None&apos; turns off authentication, so should not be
    /// used except in emergencies. &apos;Cassandra&apos; is the default
    /// password based authentication. The default is &apos;Cassandra&apos;.
    /// </summary>
    public BicepValue<CassandraAuthenticationMethod> AuthenticationMethod 
    {
        get { Initialize(); return _authenticationMethod!; }
        set { Initialize(); _authenticationMethod!.Assign(value); }
    }
    private BicepValue<CassandraAuthenticationMethod>? _authenticationMethod;

    /// <summary>
    /// Initial password for clients connecting as admin to the cluster. Should
    /// be changed after cluster creation. Returns null on GET. This field
    /// only applies when the authenticationMethod field is
    /// &apos;Cassandra&apos;.
    /// </summary>
    public BicepValue<string> InitialCassandraAdminPassword 
    {
        get { Initialize(); return _initialCassandraAdminPassword!; }
        set { Initialize(); _initialCassandraAdminPassword!.Assign(value); }
    }
    private BicepValue<string>? _initialCassandraAdminPassword;

    /// <summary>
    /// IP address of this seed node.
    /// </summary>
    public BicepValue<string> PrometheusEndpointIPAddress 
    {
        get { Initialize(); return _prometheusEndpointIPAddress!; }
        set { Initialize(); _prometheusEndpointIPAddress!.Assign(value); }
    }
    private BicepValue<string>? _prometheusEndpointIPAddress;

    /// <summary>
    /// Should automatic repairs run on this cluster? If omitted, this is true,
    /// and should stay true unless you are running a hybrid cluster where you
    /// are already doing your own repairs.
    /// </summary>
    public BicepValue<bool> IsRepairEnabled 
    {
        get { Initialize(); return _isRepairEnabled!; }
        set { Initialize(); _isRepairEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRepairEnabled;

    /// <summary>
    /// The form of AutoReplicate that is being used by this cluster.
    /// </summary>
    public BicepValue<CassandraAutoReplicateForm> AutoReplicate 
    {
        get { Initialize(); return _autoReplicate!; }
        set { Initialize(); _autoReplicate!.Assign(value); }
    }
    private BicepValue<CassandraAutoReplicateForm>? _autoReplicate;

    /// <summary>
    /// List of TLS certificates used to authorize clients connecting to the
    /// cluster. All connections are TLS encrypted whether clientCertificates
    /// is set or not, but if clientCertificates is set, the managed Cassandra
    /// cluster will reject all connections not bearing a TLS client
    /// certificate that can be validated from one or more of the public
    /// certificates in this property.
    /// </summary>
    public BicepList<CassandraCertificate> ClientCertificates 
    {
        get { Initialize(); return _clientCertificates!; }
        set { Initialize(); _clientCertificates!.Assign(value); }
    }
    private BicepList<CassandraCertificate>? _clientCertificates;

    /// <summary>
    /// List of TLS certificates used to authorize gossip from unmanaged data
    /// centers. The TLS certificates of all nodes in unmanaged data centers
    /// must be verifiable using one of the certificates provided in this
    /// property.
    /// </summary>
    public BicepList<CassandraCertificate> ExternalGossipCertificates 
    {
        get { Initialize(); return _externalGossipCertificates!; }
        set { Initialize(); _externalGossipCertificates!.Assign(value); }
    }
    private BicepList<CassandraCertificate>? _externalGossipCertificates;

    /// <summary>
    /// List of TLS certificates that unmanaged nodes must trust for gossip
    /// with managed nodes. All managed nodes will present TLS client
    /// certificates that are verifiable using one of the certificates
    /// provided in this property.
    /// </summary>
    public BicepList<CassandraCertificate> GossipCertificates 
    {
        get { Initialize(); return _gossipCertificates!; }
    }
    private BicepList<CassandraCertificate>? _gossipCertificates;

    /// <summary>
    /// List of IP addresses of seed nodes in unmanaged data centers. These
    /// will be added to the seed node lists of all managed nodes.
    /// </summary>
    public BicepList<CassandraDataCenterSeedNode> ExternalSeedNodes 
    {
        get { Initialize(); return _externalSeedNodes!; }
        set { Initialize(); _externalSeedNodes!.Assign(value); }
    }
    private BicepList<CassandraDataCenterSeedNode>? _externalSeedNodes;

    /// <summary>
    /// List of IP addresses of seed nodes in the managed data centers. These
    /// should be added to the seed node lists of all unmanaged nodes.
    /// </summary>
    public BicepList<CassandraDataCenterSeedNode> SeedNodes 
    {
        get { Initialize(); return _seedNodes!; }
    }
    private BicepList<CassandraDataCenterSeedNode>? _seedNodes;

    /// <summary>
    /// List of the data center names for unmanaged data centers in this
    /// cluster to be included in auto-replication.
    /// </summary>
    public BicepList<string> ExternalDataCenters 
    {
        get { Initialize(); return _externalDataCenters!; }
        set { Initialize(); _externalDataCenters!.Assign(value); }
    }
    private BicepList<string>? _externalDataCenters;

    /// <summary>
    /// (Deprecated) Number of hours to wait between taking a backup of the
    /// cluster.
    /// </summary>
    public BicepValue<int> HoursBetweenBackups 
    {
        get { Initialize(); return _hoursBetweenBackups!; }
        set { Initialize(); _hoursBetweenBackups!.Assign(value); }
    }
    private BicepValue<int>? _hoursBetweenBackups;

    /// <summary>
    /// Whether the cluster and associated data centers has been deallocated.
    /// </summary>
    public BicepValue<bool> IsDeallocated 
    {
        get { Initialize(); return _isDeallocated!; }
        set { Initialize(); _isDeallocated!.Assign(value); }
    }
    private BicepValue<bool>? _isDeallocated;

    /// <summary>
    /// Whether Cassandra audit logging is enabled.
    /// </summary>
    public BicepValue<bool> IsCassandraAuditLoggingEnabled 
    {
        get { Initialize(); return _isCassandraAuditLoggingEnabled!; }
        set { Initialize(); _isCassandraAuditLoggingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isCassandraAuditLoggingEnabled;

    /// <summary>
    /// Type of the cluster. If set to Production, some operations might not be
    /// permitted on cluster.
    /// </summary>
    public BicepValue<CassandraClusterType> ClusterType 
    {
        get { Initialize(); return _clusterType!; }
        set { Initialize(); _clusterType!.Assign(value); }
    }
    private BicepValue<CassandraClusterType>? _clusterType;

    /// <summary>
    /// Error related to resource provisioning.
    /// </summary>
    public CassandraError ProvisionError 
    {
        get { Initialize(); return _provisionError!; }
        set { Initialize(); AssignOrReplace(ref _provisionError, value); }
    }
    private CassandraError? _provisionError;

    /// <summary>
    /// Extensions to be added or updated on cluster.
    /// </summary>
    public BicepList<string> Extensions 
    {
        get { Initialize(); return _extensions!; }
        set { Initialize(); _extensions!.Assign(value); }
    }
    private BicepList<string>? _extensions;

    /// <summary>
    /// List of backup schedules that define when you want to back up your data.
    /// </summary>
    public BicepList<CassandraClusterBackupSchedule> BackupSchedules 
    {
        get { Initialize(); return _backupSchedules!; }
        set { Initialize(); _backupSchedules!.Assign(value); }
    }
    private BicepList<CassandraClusterBackupSchedule>? _backupSchedules;

    /// <summary>
    /// How the nodes in the cluster react to scheduled events.
    /// </summary>
    public BicepValue<ScheduledEventStrategy> ScheduledEventStrategy 
    {
        get { Initialize(); return _scheduledEventStrategy!; }
        set { Initialize(); _scheduledEventStrategy!.Assign(value); }
    }
    private BicepValue<ScheduledEventStrategy>? _scheduledEventStrategy;

    /// <summary>
    /// How to connect to the azure services needed for running the cluster.
    /// </summary>
    public BicepValue<ServiceConnectionType> AzureConnectionMethod 
    {
        get { Initialize(); return _azureConnectionMethod!; }
        set { Initialize(); _azureConnectionMethod!.Assign(value); }
    }
    private BicepValue<ServiceConnectionType>? _azureConnectionMethod;

    /// <summary>
    /// If the Connection Method is Vpn, this is the Id of the private link
    /// resource that the datacenters need to connect to.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateLinkResourceId 
    {
        get { Initialize(); return _privateLinkResourceId!; }
    }
    private BicepValue<ResourceIdentifier>? _privateLinkResourceId;

    /// <summary>
    /// Creates a new CassandraClusterProperties.
    /// </summary>
    public CassandraClusterProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CassandraClusterProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _provisioningState = DefineProperty<CassandraProvisioningState>("ProvisioningState", ["provisioningState"]);
        _restoreFromBackupId = DefineProperty<string>("RestoreFromBackupId", ["restoreFromBackupId"]);
        _delegatedManagementSubnetId = DefineProperty<ResourceIdentifier>("DelegatedManagementSubnetId", ["delegatedManagementSubnetId"]);
        _cassandraVersion = DefineProperty<string>("CassandraVersion", ["cassandraVersion"]);
        _clusterNameOverride = DefineProperty<string>("ClusterNameOverride", ["clusterNameOverride"]);
        _authenticationMethod = DefineProperty<CassandraAuthenticationMethod>("AuthenticationMethod", ["authenticationMethod"]);
        _initialCassandraAdminPassword = DefineProperty<string>("InitialCassandraAdminPassword", ["initialCassandraAdminPassword"]);
        _prometheusEndpointIPAddress = DefineProperty<string>("PrometheusEndpointIPAddress", ["prometheusEndpoint", "ipAddress"]);
        _isRepairEnabled = DefineProperty<bool>("IsRepairEnabled", ["repairEnabled"]);
        _autoReplicate = DefineProperty<CassandraAutoReplicateForm>("AutoReplicate", ["autoReplicate"]);
        _clientCertificates = DefineListProperty<CassandraCertificate>("ClientCertificates", ["clientCertificates"]);
        _externalGossipCertificates = DefineListProperty<CassandraCertificate>("ExternalGossipCertificates", ["externalGossipCertificates"]);
        _gossipCertificates = DefineListProperty<CassandraCertificate>("GossipCertificates", ["gossipCertificates"], isOutput: true);
        _externalSeedNodes = DefineListProperty<CassandraDataCenterSeedNode>("ExternalSeedNodes", ["externalSeedNodes"]);
        _seedNodes = DefineListProperty<CassandraDataCenterSeedNode>("SeedNodes", ["seedNodes"], isOutput: true);
        _externalDataCenters = DefineListProperty<string>("ExternalDataCenters", ["externalDataCenters"]);
        _hoursBetweenBackups = DefineProperty<int>("HoursBetweenBackups", ["hoursBetweenBackups"]);
        _isDeallocated = DefineProperty<bool>("IsDeallocated", ["deallocated"]);
        _isCassandraAuditLoggingEnabled = DefineProperty<bool>("IsCassandraAuditLoggingEnabled", ["cassandraAuditLoggingEnabled"]);
        _clusterType = DefineProperty<CassandraClusterType>("ClusterType", ["clusterType"]);
        _provisionError = DefineModelProperty<CassandraError>("ProvisionError", ["provisionError"]);
        _extensions = DefineListProperty<string>("Extensions", ["extensions"]);
        _backupSchedules = DefineListProperty<CassandraClusterBackupSchedule>("BackupSchedules", ["backupSchedules"]);
        _scheduledEventStrategy = DefineProperty<ScheduledEventStrategy>("ScheduledEventStrategy", ["scheduledEventStrategy"]);
        _azureConnectionMethod = DefineProperty<ServiceConnectionType>("AzureConnectionMethod", ["azureConnectionMethod"]);
        _privateLinkResourceId = DefineProperty<ResourceIdentifier>("PrivateLinkResourceId", ["privateLinkResourceId"], isOutput: true);
    }
}
