// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB Cassandra table cluster key.
/// </summary>
public partial class CassandraClusterKey : ProvisionableConstruct
{
    /// <summary>
    /// Name of the Cosmos DB Cassandra table cluster key.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Order of the Cosmos DB Cassandra table cluster key, only support
    /// &quot;Asc&quot; and &quot;Desc&quot;.
    /// </summary>
    public BicepValue<string> OrderBy 
    {
        get { Initialize(); return _orderBy!; }
        set { Initialize(); _orderBy!.Assign(value); }
    }
    private BicepValue<string>? _orderBy;

    /// <summary>
    /// Creates a new CassandraClusterKey.
    /// </summary>
    public CassandraClusterKey()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CassandraClusterKey.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _orderBy = DefineProperty<string>("OrderBy", ["orderBy"]);
    }
}
