// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The CassandraClusterBackupSchedule.
/// </summary>
public partial class CassandraClusterBackupSchedule : ProvisionableConstruct
{
    /// <summary>
    /// The unique identifier of backup schedule.
    /// </summary>
    public BicepValue<string> ScheduleName 
    {
        get { Initialize(); return _scheduleName!; }
        set { Initialize(); _scheduleName!.Assign(value); }
    }
    private BicepValue<string>? _scheduleName;

    /// <summary>
    /// The cron expression that defines when you want to back up your data.
    /// </summary>
    public BicepValue<string> CronExpression 
    {
        get { Initialize(); return _cronExpression!; }
        set { Initialize(); _cronExpression!.Assign(value); }
    }
    private BicepValue<string>? _cronExpression;

    /// <summary>
    /// The retention period (hours) of the backups. If you want to retain data
    /// forever, set retention to 0.
    /// </summary>
    public BicepValue<int> RetentionInHours 
    {
        get { Initialize(); return _retentionInHours!; }
        set { Initialize(); _retentionInHours!.Assign(value); }
    }
    private BicepValue<int>? _retentionInHours;

    /// <summary>
    /// Creates a new CassandraClusterBackupSchedule.
    /// </summary>
    public CassandraClusterBackupSchedule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// CassandraClusterBackupSchedule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _scheduleName = DefineProperty<string>("ScheduleName", ["scheduleName"]);
        _cronExpression = DefineProperty<string>("CronExpression", ["cronExpression"]);
        _retentionInHours = DefineProperty<int>("RetentionInHours", ["retentionInHours"]);
    }
}
