// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The CassandraCertificate.
/// </summary>
public partial class CassandraCertificate : ProvisionableConstruct
{
    /// <summary>
    /// PEM formatted public key.
    /// </summary>
    public BicepValue<string> Pem 
    {
        get { Initialize(); return _pem!; }
        set { Initialize(); _pem!.Assign(value); }
    }
    private BicepValue<string>? _pem;

    /// <summary>
    /// Creates a new CassandraCertificate.
    /// </summary>
    public CassandraCertificate()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of CassandraCertificate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _pem = DefineProperty<string>("Pem", ["pem"]);
    }
}
