// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// A base CosmosDB data source/sink             Please note
/// Azure.ResourceManager.CosmosDB.Models.BaseCosmosDataTransferDataSourceSink
/// is the base class. According to the scenario, a derived class of the base
/// class might need to be assigned here, or this property needs to be casted
/// to one of the possible derived classes.             The available derived
/// classes include
/// Azure.ResourceManager.CosmosDB.Models.CosmosCassandraDataTransferDataSourceSink,
/// Azure.ResourceManager.CosmosDB.Models.CosmosMongoDataTransferDataSourceSink
/// and
/// Azure.ResourceManager.CosmosDB.Models.CosmosSqlDataTransferDataSourceSink.
/// </summary>
public partial class BaseCosmosDataTransferDataSourceSink : DataTransferDataSourceSink
{
    /// <summary>
    /// Gets or sets the remote account name.
    /// </summary>
    public BicepValue<string> RemoteAccountName 
    {
        get { Initialize(); return _remoteAccountName!; }
        set { Initialize(); _remoteAccountName!.Assign(value); }
    }
    private BicepValue<string>? _remoteAccountName;

    /// <summary>
    /// Creates a new BaseCosmosDataTransferDataSourceSink.
    /// </summary>
    public BaseCosmosDataTransferDataSourceSink() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// BaseCosmosDataTransferDataSourceSink.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("component", ["component"], defaultValue: "BaseCosmosDataTransferDataSourceSink");
        _remoteAccountName = DefineProperty<string>("RemoteAccountName", ["remoteAccountName"]);
    }
}
