// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// The object representing the state of the migration between the backup
/// policies.
/// </summary>
public partial class BackupPolicyMigrationState : ProvisionableConstruct
{
    /// <summary>
    /// Describes the status of migration between backup policy types.
    /// </summary>
    public BicepValue<BackupPolicyMigrationStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<BackupPolicyMigrationStatus>? _status;

    /// <summary>
    /// Describes the target backup policy type of the backup policy migration.
    /// </summary>
    public BicepValue<BackupPolicyType> TargetType 
    {
        get { Initialize(); return _targetType!; }
        set { Initialize(); _targetType!.Assign(value); }
    }
    private BicepValue<BackupPolicyType>? _targetType;

    /// <summary>
    /// Time at which the backup policy migration started (ISO-8601 format).
    /// </summary>
    public BicepValue<DateTimeOffset> StartOn 
    {
        get { Initialize(); return _startOn!; }
        set { Initialize(); _startOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _startOn;

    /// <summary>
    /// Creates a new BackupPolicyMigrationState.
    /// </summary>
    public BackupPolicyMigrationState()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BackupPolicyMigrationState.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<BackupPolicyMigrationStatus>("Status", ["status"]);
        _targetType = DefineProperty<BackupPolicyType>("TargetType", ["targetType"]);
        _startOn = DefineProperty<DateTimeOffset>("StartOn", ["startTime"]);
    }
}
