// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// An Azure Blob Storage data source/sink.
/// </summary>
public partial class AzureBlobDataTransferDataSourceSink : DataTransferDataSourceSink
{
    /// <summary>
    /// Gets or sets the container name.
    /// </summary>
    public BicepValue<string> ContainerName 
    {
        get { Initialize(); return _containerName!; }
        set { Initialize(); _containerName!.Assign(value); }
    }
    private BicepValue<string>? _containerName;

    /// <summary>
    /// Gets or sets the endpoint uri.
    /// </summary>
    public BicepValue<Uri> EndpointUri 
    {
        get { Initialize(); return _endpointUri!; }
        set { Initialize(); _endpointUri!.Assign(value); }
    }
    private BicepValue<Uri>? _endpointUri;

    /// <summary>
    /// Creates a new AzureBlobDataTransferDataSourceSink.
    /// </summary>
    public AzureBlobDataTransferDataSourceSink() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// AzureBlobDataTransferDataSourceSink.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("component", ["component"], defaultValue: "AzureBlobStorage");
        _containerName = DefineProperty<string>("ContainerName", ["containerName"]);
        _endpointUri = DefineProperty<Uri>("EndpointUri", ["endpointUrl"]);
    }
}
