// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Cosmos DB provisioned throughput settings object.
/// </summary>
public partial class AutoscaleSettingsResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// Represents maximum throughput container can scale up to.
    /// </summary>
    public BicepValue<int> MaxThroughput 
    {
        get { Initialize(); return _maxThroughput!; }
        set { Initialize(); _maxThroughput!.Assign(value); }
    }
    private BicepValue<int>? _maxThroughput;

    /// <summary>
    /// Represents throughput policy which service must adhere to for
    /// auto-upgrade.
    /// </summary>
    public ThroughputPolicyResourceInfo AutoUpgradeThroughputPolicy 
    {
        get { Initialize(); return _autoUpgradeThroughputPolicy!; }
        set { Initialize(); AssignOrReplace(ref _autoUpgradeThroughputPolicy, value); }
    }
    private ThroughputPolicyResourceInfo? _autoUpgradeThroughputPolicy;

    /// <summary>
    /// Represents target maximum throughput container can scale up to once
    /// offer is no longer in pending state.
    /// </summary>
    public BicepValue<int> TargetMaxThroughput 
    {
        get { Initialize(); return _targetMaxThroughput!; }
    }
    private BicepValue<int>? _targetMaxThroughput;

    /// <summary>
    /// Creates a new AutoscaleSettingsResourceInfo.
    /// </summary>
    public AutoscaleSettingsResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// AutoscaleSettingsResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _maxThroughput = DefineProperty<int>("MaxThroughput", ["maxThroughput"]);
        _autoUpgradeThroughputPolicy = DefineModelProperty<ThroughputPolicyResourceInfo>("AutoUpgradeThroughputPolicy", ["autoUpgradePolicy", "throughputPolicy"]);
        _targetMaxThroughput = DefineProperty<int>("TargetMaxThroughput", ["targetMaxThroughput"], isOutput: true);
    }
}
