// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// DataTransferJobGetResult.
/// </summary>
public partial class DataTransferJobGetResult : ProvisionableResource
{
    /// <summary>
    /// Name of the Data Transfer Job.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Data Transfer Create Job Properties.
    /// </summary>
    public DataTransferJobProperties Properties 
    {
        get { Initialize(); return _properties!; }
        set { Initialize(); AssignOrReplace(ref _properties, value); }
    }
    private DataTransferJobProperties? _properties;

    /// <summary>
    /// Destination DataStore details             Please note
    /// Azure.ResourceManager.CosmosDB.Models.DataTransferDataSourceSink is
    /// the base class. According to the scenario, a derived class of the base
    /// class might need to be assigned here, or this property needs to be
    /// casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.CosmosDB.Models.AzureBlobDataTransferDataSourceSink,
    /// Azure.ResourceManager.CosmosDB.Models.BaseCosmosDataTransferDataSourceSink,
    /// Azure.ResourceManager.CosmosDB.Models.CosmosCassandraDataTransferDataSourceSink,
    /// Azure.ResourceManager.CosmosDB.Models.CosmosMongoDataTransferDataSourceSink
    /// and
    /// Azure.ResourceManager.CosmosDB.Models.CosmosSqlDataTransferDataSourceSink.
    /// </summary>
    public DataTransferDataSourceSink Destination 
    {
        get { Initialize(); return _destination!; }
    }
    private DataTransferDataSourceSink? _destination;

    /// <summary>
    /// Total Duration of Job.
    /// </summary>
    public BicepValue<TimeSpan> Duration 
    {
        get { Initialize(); return _duration!; }
    }
    private BicepValue<TimeSpan>? _duration;

    /// <summary>
    /// Error response for Faulted job.
    /// </summary>
    public ErrorResponse Error 
    {
        get { Initialize(); return _error!; }
    }
    private ErrorResponse? _error;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Job Name.
    /// </summary>
    public BicepValue<string> JobName 
    {
        get { Initialize(); return _jobName!; }
    }
    private BicepValue<string>? _jobName;

    /// <summary>
    /// Last Updated Time (ISO-8601 format).
    /// </summary>
    public BicepValue<DateTimeOffset> LastUpdatedUtcOn 
    {
        get { Initialize(); return _lastUpdatedUtcOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastUpdatedUtcOn;

    /// <summary>
    /// Mode of job execution.
    /// </summary>
    public BicepValue<DataTransferJobMode> Mode 
    {
        get { Initialize(); return _mode!; }
    }
    private BicepValue<DataTransferJobMode>? _mode;

    /// <summary>
    /// Processed Count.
    /// </summary>
    public BicepValue<long> ProcessedCount 
    {
        get { Initialize(); return _processedCount!; }
    }
    private BicepValue<long>? _processedCount;

    /// <summary>
    /// Source DataStore details             Please note
    /// Azure.ResourceManager.CosmosDB.Models.DataTransferDataSourceSink is
    /// the base class. According to the scenario, a derived class of the base
    /// class might need to be assigned here, or this property needs to be
    /// casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.CosmosDB.Models.AzureBlobDataTransferDataSourceSink,
    /// Azure.ResourceManager.CosmosDB.Models.BaseCosmosDataTransferDataSourceSink,
    /// Azure.ResourceManager.CosmosDB.Models.CosmosCassandraDataTransferDataSourceSink,
    /// Azure.ResourceManager.CosmosDB.Models.CosmosMongoDataTransferDataSourceSink
    /// and
    /// Azure.ResourceManager.CosmosDB.Models.CosmosSqlDataTransferDataSourceSink.
    /// </summary>
    public DataTransferDataSourceSink Source 
    {
        get { Initialize(); return _source!; }
    }
    private DataTransferDataSourceSink? _source;

    /// <summary>
    /// Job Status.
    /// </summary>
    public BicepValue<string> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<string>? _status;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Total Count.
    /// </summary>
    public BicepValue<long> TotalCount 
    {
        get { Initialize(); return _totalCount!; }
    }
    private BicepValue<long>? _totalCount;

    /// <summary>
    /// Worker count.
    /// </summary>
    public BicepValue<int> WorkerCount 
    {
        get { Initialize(); return _workerCount!; }
    }
    private BicepValue<int>? _workerCount;

    /// <summary>
    /// Gets or sets a reference to the parent CosmosDBAccount.
    /// </summary>
    public CosmosDBAccount? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<CosmosDBAccount>? _parent;

    /// <summary>
    /// Creates a new DataTransferJobGetResult.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the DataTransferJobGetResult resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the DataTransferJobGetResult.</param>
    public DataTransferJobGetResult(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.DocumentDB/databaseAccounts/dataTransferJobs", resourceVersion ?? "2024-08-15")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of DataTransferJobGetResult.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _properties = DefineModelProperty<DataTransferJobProperties>("Properties", ["properties"], isRequired: true);
        _destination = DefineModelProperty<DataTransferDataSourceSink>("Destination", ["properties", "destination"], isOutput: true);
        _duration = DefineProperty<TimeSpan>("Duration", ["properties", "duration"], isOutput: true);
        _error = DefineModelProperty<ErrorResponse>("Error", ["properties", "error"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _jobName = DefineProperty<string>("JobName", ["properties", "jobName"], isOutput: true);
        _lastUpdatedUtcOn = DefineProperty<DateTimeOffset>("LastUpdatedUtcOn", ["properties", "lastUpdatedUtcTime"], isOutput: true);
        _mode = DefineProperty<DataTransferJobMode>("Mode", ["properties", "mode"], isOutput: true);
        _processedCount = DefineProperty<long>("ProcessedCount", ["properties", "processedCount"], isOutput: true);
        _source = DefineModelProperty<DataTransferDataSourceSink>("Source", ["properties", "source"], isOutput: true);
        _status = DefineProperty<string>("Status", ["properties", "status"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _totalCount = DefineProperty<long>("TotalCount", ["properties", "totalCount"], isOutput: true);
        _workerCount = DefineProperty<int>("WorkerCount", ["properties", "workerCount"], isOutput: true);
        _parent = DefineResource<CosmosDBAccount>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported DataTransferJobGetResult resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-08-15.
        /// </summary>
        public static readonly string V2024_08_15 = "2024-08-15";

        /// <summary>
        /// 2024-05-15.
        /// </summary>
        public static readonly string V2024_05_15 = "2024-05-15";

        /// <summary>
        /// 2023-11-15.
        /// </summary>
        public static readonly string V2023_11_15 = "2023-11-15";

        /// <summary>
        /// 2023-09-15.
        /// </summary>
        public static readonly string V2023_09_15 = "2023-09-15";

        /// <summary>
        /// 2023-04-15.
        /// </summary>
        public static readonly string V2023_04_15 = "2023-04-15";

        /// <summary>
        /// 2023-03-15.
        /// </summary>
        public static readonly string V2023_03_15 = "2023-03-15";

        /// <summary>
        /// 2022-11-15.
        /// </summary>
        public static readonly string V2022_11_15 = "2022-11-15";

        /// <summary>
        /// 2022-08-15.
        /// </summary>
        public static readonly string V2022_08_15 = "2022-08-15";

        /// <summary>
        /// 2022-05-15.
        /// </summary>
        public static readonly string V2022_05_15 = "2022-05-15";

        /// <summary>
        /// 2021-10-15.
        /// </summary>
        public static readonly string V2021_10_15 = "2021-10-15";

        /// <summary>
        /// 2021-06-15.
        /// </summary>
        public static readonly string V2021_06_15 = "2021-06-15";

        /// <summary>
        /// 2021-05-15.
        /// </summary>
        public static readonly string V2021_05_15 = "2021-05-15";

        /// <summary>
        /// 2021-04-15.
        /// </summary>
        public static readonly string V2021_04_15 = "2021-04-15";

        /// <summary>
        /// 2021-03-15.
        /// </summary>
        public static readonly string V2021_03_15 = "2021-03-15";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-04-01.
        /// </summary>
        public static readonly string V2020_04_01 = "2020-04-01";

        /// <summary>
        /// 2020-03-01.
        /// </summary>
        public static readonly string V2020_03_01 = "2020-03-01";

        /// <summary>
        /// 2019-12-12.
        /// </summary>
        public static readonly string V2019_12_12 = "2019-12-12";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2016-03-31.
        /// </summary>
        public static readonly string V2016_03_31 = "2016-03-31";

        /// <summary>
        /// 2016-03-19.
        /// </summary>
        public static readonly string V2016_03_19 = "2016-03-19";

        /// <summary>
        /// 2015-11-06.
        /// </summary>
        public static readonly string V2015_11_06 = "2015-11-06";

        /// <summary>
        /// 2015-04-08.
        /// </summary>
        public static readonly string V2015_04_08 = "2015-04-08";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing DataTransferJobGetResult.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the DataTransferJobGetResult resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the DataTransferJobGetResult.</param>
    /// <returns>The existing DataTransferJobGetResult resource.</returns>
    public static DataTransferJobGetResult FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
