// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.CosmosDB;

/// <summary>
/// Built-in CosmosDB roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct CosmosDBBuiltInRole(string value) : IEquatable<CosmosDBBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Can read Azure Cosmos DB account data. See DocumentDB Account
    /// Contributor for managing Azure Cosmos DB accounts.
    /// </summary>
    public static CosmosDBBuiltInRole CosmosDBAccountReaderRole { get; } = new(CosmosDBAccountReaderRoleValue);
    internal const string CosmosDBAccountReaderRoleValue = "fbdf93bf-df7d-467e-a4d2-9458aa1360c8";

    /// <summary>
    /// Lets you manage Azure Cosmos DB accounts, but not access data in them.
    /// Prevents access to account keys and connection strings.
    /// </summary>
    public static CosmosDBBuiltInRole CosmosDBOperator { get; } = new(CosmosDBOperatorValue);
    internal const string CosmosDBOperatorValue = "230815da-be43-4aae-9cb4-875f7bd000aa";

    /// <summary>
    /// Can submit restore request for a Cosmos DB database or a container for
    /// an account
    /// </summary>
    public static CosmosDBBuiltInRole CosmosBackupOperator { get; } = new(CosmosBackupOperatorValue);
    internal const string CosmosBackupOperatorValue = "db7b14f2-5adf-42da-9f96-f2ee17bab5cb";

    /// <summary>
    /// Can perform restore action for Cosmos DB database account with
    /// continuous backup mode
    /// </summary>
    public static CosmosDBBuiltInRole CosmosRestoreOperator { get; } = new(CosmosRestoreOperatorValue);
    internal const string CosmosRestoreOperatorValue = "5432c526-bc82-444a-b7ba-57c5b0b5b34f";

    /// <summary>
    /// Can manage Azure Cosmos DB accounts. Azure Cosmos DB is formerly known
    /// as DocumentDB.
    /// </summary>
    public static CosmosDBBuiltInRole DocumentDBAccountContributor { get; } = new(DocumentDBAccountContributorValue);
    internal const string DocumentDBAccountContributorValue = "5bd9cd88-fe45-4216-938b-f97437e15450";

    /// <summary>
    /// Try to get the name of a built-in CosmosDB role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in CosmosDB role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(CosmosDBBuiltInRole value) =>
        value._value switch
        {
            CosmosDBAccountReaderRoleValue => nameof(CosmosDBAccountReaderRole),
            CosmosDBOperatorValue => nameof(CosmosDBOperator),
            CosmosBackupOperatorValue => nameof(CosmosBackupOperator),
            CosmosRestoreOperatorValue => nameof(CosmosRestoreOperator),
            DocumentDBAccountContributorValue => nameof(DocumentDBAccountContributor),
            _ => value._value
        };

    /// <summary>
    /// Determines if two CosmosDBBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first CosmosDBBuiltInRole to compare.</param>
    /// <param name="right">The second CosmosDBBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(CosmosDBBuiltInRole left, CosmosDBBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two CosmosDBBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first CosmosDBBuiltInRole to compare.</param>
    /// <param name="right">The second CosmosDBBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(CosmosDBBuiltInRole left, CosmosDBBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a CosmosDBBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator CosmosDBBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is CosmosDBBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(CosmosDBBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
