// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Sysctl settings for Linux agent nodes.
/// </summary>
public partial class SysctlConfig : ProvisionableConstruct
{
    /// <summary>
    /// Sysctl setting net.core.somaxconn.
    /// </summary>
    public BicepValue<int> NetCoreSomaxconn 
    {
        get { Initialize(); return _netCoreSomaxconn!; }
        set { Initialize(); _netCoreSomaxconn!.Assign(value); }
    }
    private BicepValue<int>? _netCoreSomaxconn;

    /// <summary>
    /// Sysctl setting net.core.netdev_max_backlog.
    /// </summary>
    public BicepValue<int> NetCoreNetdevMaxBacklog 
    {
        get { Initialize(); return _netCoreNetdevMaxBacklog!; }
        set { Initialize(); _netCoreNetdevMaxBacklog!.Assign(value); }
    }
    private BicepValue<int>? _netCoreNetdevMaxBacklog;

    /// <summary>
    /// Sysctl setting net.core.rmem_default.
    /// </summary>
    public BicepValue<int> NetCoreRmemDefault 
    {
        get { Initialize(); return _netCoreRmemDefault!; }
        set { Initialize(); _netCoreRmemDefault!.Assign(value); }
    }
    private BicepValue<int>? _netCoreRmemDefault;

    /// <summary>
    /// Sysctl setting net.core.rmem_max.
    /// </summary>
    public BicepValue<int> NetCoreRmemMax 
    {
        get { Initialize(); return _netCoreRmemMax!; }
        set { Initialize(); _netCoreRmemMax!.Assign(value); }
    }
    private BicepValue<int>? _netCoreRmemMax;

    /// <summary>
    /// Sysctl setting net.core.wmem_default.
    /// </summary>
    public BicepValue<int> NetCoreWmemDefault 
    {
        get { Initialize(); return _netCoreWmemDefault!; }
        set { Initialize(); _netCoreWmemDefault!.Assign(value); }
    }
    private BicepValue<int>? _netCoreWmemDefault;

    /// <summary>
    /// Sysctl setting net.core.wmem_max.
    /// </summary>
    public BicepValue<int> NetCoreWmemMax 
    {
        get { Initialize(); return _netCoreWmemMax!; }
        set { Initialize(); _netCoreWmemMax!.Assign(value); }
    }
    private BicepValue<int>? _netCoreWmemMax;

    /// <summary>
    /// Sysctl setting net.core.optmem_max.
    /// </summary>
    public BicepValue<int> NetCoreOptmemMax 
    {
        get { Initialize(); return _netCoreOptmemMax!; }
        set { Initialize(); _netCoreOptmemMax!.Assign(value); }
    }
    private BicepValue<int>? _netCoreOptmemMax;

    /// <summary>
    /// Sysctl setting net.ipv4.tcp_max_syn_backlog.
    /// </summary>
    public BicepValue<int> NetIPv4TcpMaxSynBacklog 
    {
        get { Initialize(); return _netIPv4TcpMaxSynBacklog!; }
        set { Initialize(); _netIPv4TcpMaxSynBacklog!.Assign(value); }
    }
    private BicepValue<int>? _netIPv4TcpMaxSynBacklog;

    /// <summary>
    /// Sysctl setting net.ipv4.tcp_max_tw_buckets.
    /// </summary>
    public BicepValue<int> NetIPv4TcpMaxTwBuckets 
    {
        get { Initialize(); return _netIPv4TcpMaxTwBuckets!; }
        set { Initialize(); _netIPv4TcpMaxTwBuckets!.Assign(value); }
    }
    private BicepValue<int>? _netIPv4TcpMaxTwBuckets;

    /// <summary>
    /// Sysctl setting net.ipv4.tcp_fin_timeout.
    /// </summary>
    public BicepValue<int> NetIPv4TcpFinTimeout 
    {
        get { Initialize(); return _netIPv4TcpFinTimeout!; }
        set { Initialize(); _netIPv4TcpFinTimeout!.Assign(value); }
    }
    private BicepValue<int>? _netIPv4TcpFinTimeout;

    /// <summary>
    /// Sysctl setting net.ipv4.tcp_keepalive_time.
    /// </summary>
    public BicepValue<int> NetIPv4TcpKeepaliveTime 
    {
        get { Initialize(); return _netIPv4TcpKeepaliveTime!; }
        set { Initialize(); _netIPv4TcpKeepaliveTime!.Assign(value); }
    }
    private BicepValue<int>? _netIPv4TcpKeepaliveTime;

    /// <summary>
    /// Sysctl setting net.ipv4.tcp_keepalive_probes.
    /// </summary>
    public BicepValue<int> NetIPv4TcpKeepaliveProbes 
    {
        get { Initialize(); return _netIPv4TcpKeepaliveProbes!; }
        set { Initialize(); _netIPv4TcpKeepaliveProbes!.Assign(value); }
    }
    private BicepValue<int>? _netIPv4TcpKeepaliveProbes;

    /// <summary>
    /// Sysctl setting net.ipv4.tcp_keepalive_intvl.
    /// </summary>
    public BicepValue<int> NetIPv4TcpKeepaliveIntvl 
    {
        get { Initialize(); return _netIPv4TcpKeepaliveIntvl!; }
        set { Initialize(); _netIPv4TcpKeepaliveIntvl!.Assign(value); }
    }
    private BicepValue<int>? _netIPv4TcpKeepaliveIntvl;

    /// <summary>
    /// Sysctl setting net.ipv4.tcp_tw_reuse.
    /// </summary>
    public BicepValue<bool> NetIPv4TcpTwReuse 
    {
        get { Initialize(); return _netIPv4TcpTwReuse!; }
        set { Initialize(); _netIPv4TcpTwReuse!.Assign(value); }
    }
    private BicepValue<bool>? _netIPv4TcpTwReuse;

    /// <summary>
    /// Sysctl setting net.ipv4.ip_local_port_range.
    /// </summary>
    public BicepValue<string> NetIPv4IPLocalPortRange 
    {
        get { Initialize(); return _netIPv4IPLocalPortRange!; }
        set { Initialize(); _netIPv4IPLocalPortRange!.Assign(value); }
    }
    private BicepValue<string>? _netIPv4IPLocalPortRange;

    /// <summary>
    /// Sysctl setting net.ipv4.neigh.default.gc_thresh1.
    /// </summary>
    public BicepValue<int> NetIPv4NeighDefaultGcThresh1 
    {
        get { Initialize(); return _netIPv4NeighDefaultGcThresh1!; }
        set { Initialize(); _netIPv4NeighDefaultGcThresh1!.Assign(value); }
    }
    private BicepValue<int>? _netIPv4NeighDefaultGcThresh1;

    /// <summary>
    /// Sysctl setting net.ipv4.neigh.default.gc_thresh2.
    /// </summary>
    public BicepValue<int> NetIPv4NeighDefaultGcThresh2 
    {
        get { Initialize(); return _netIPv4NeighDefaultGcThresh2!; }
        set { Initialize(); _netIPv4NeighDefaultGcThresh2!.Assign(value); }
    }
    private BicepValue<int>? _netIPv4NeighDefaultGcThresh2;

    /// <summary>
    /// Sysctl setting net.ipv4.neigh.default.gc_thresh3.
    /// </summary>
    public BicepValue<int> NetIPv4NeighDefaultGcThresh3 
    {
        get { Initialize(); return _netIPv4NeighDefaultGcThresh3!; }
        set { Initialize(); _netIPv4NeighDefaultGcThresh3!.Assign(value); }
    }
    private BicepValue<int>? _netIPv4NeighDefaultGcThresh3;

    /// <summary>
    /// Sysctl setting net.netfilter.nf_conntrack_max.
    /// </summary>
    public BicepValue<int> NetNetfilterNfConntrackMax 
    {
        get { Initialize(); return _netNetfilterNfConntrackMax!; }
        set { Initialize(); _netNetfilterNfConntrackMax!.Assign(value); }
    }
    private BicepValue<int>? _netNetfilterNfConntrackMax;

    /// <summary>
    /// Sysctl setting net.netfilter.nf_conntrack_buckets.
    /// </summary>
    public BicepValue<int> NetNetfilterNfConntrackBuckets 
    {
        get { Initialize(); return _netNetfilterNfConntrackBuckets!; }
        set { Initialize(); _netNetfilterNfConntrackBuckets!.Assign(value); }
    }
    private BicepValue<int>? _netNetfilterNfConntrackBuckets;

    /// <summary>
    /// Sysctl setting fs.inotify.max_user_watches.
    /// </summary>
    public BicepValue<int> FsInotifyMaxUserWatches 
    {
        get { Initialize(); return _fsInotifyMaxUserWatches!; }
        set { Initialize(); _fsInotifyMaxUserWatches!.Assign(value); }
    }
    private BicepValue<int>? _fsInotifyMaxUserWatches;

    /// <summary>
    /// Sysctl setting fs.file-max.
    /// </summary>
    public BicepValue<int> FsFileMax 
    {
        get { Initialize(); return _fsFileMax!; }
        set { Initialize(); _fsFileMax!.Assign(value); }
    }
    private BicepValue<int>? _fsFileMax;

    /// <summary>
    /// Sysctl setting fs.aio-max-nr.
    /// </summary>
    public BicepValue<int> FsAioMaxNr 
    {
        get { Initialize(); return _fsAioMaxNr!; }
        set { Initialize(); _fsAioMaxNr!.Assign(value); }
    }
    private BicepValue<int>? _fsAioMaxNr;

    /// <summary>
    /// Sysctl setting fs.nr_open.
    /// </summary>
    public BicepValue<int> FsNrOpen 
    {
        get { Initialize(); return _fsNrOpen!; }
        set { Initialize(); _fsNrOpen!.Assign(value); }
    }
    private BicepValue<int>? _fsNrOpen;

    /// <summary>
    /// Sysctl setting kernel.threads-max.
    /// </summary>
    public BicepValue<int> KernelThreadsMax 
    {
        get { Initialize(); return _kernelThreadsMax!; }
        set { Initialize(); _kernelThreadsMax!.Assign(value); }
    }
    private BicepValue<int>? _kernelThreadsMax;

    /// <summary>
    /// Sysctl setting vm.max_map_count.
    /// </summary>
    public BicepValue<int> VmMaxMapCount 
    {
        get { Initialize(); return _vmMaxMapCount!; }
        set { Initialize(); _vmMaxMapCount!.Assign(value); }
    }
    private BicepValue<int>? _vmMaxMapCount;

    /// <summary>
    /// Sysctl setting vm.swappiness.
    /// </summary>
    public BicepValue<int> VmSwappiness 
    {
        get { Initialize(); return _vmSwappiness!; }
        set { Initialize(); _vmSwappiness!.Assign(value); }
    }
    private BicepValue<int>? _vmSwappiness;

    /// <summary>
    /// Sysctl setting vm.vfs_cache_pressure.
    /// </summary>
    public BicepValue<int> VmVfsCachePressure 
    {
        get { Initialize(); return _vmVfsCachePressure!; }
        set { Initialize(); _vmVfsCachePressure!.Assign(value); }
    }
    private BicepValue<int>? _vmVfsCachePressure;

    /// <summary>
    /// Creates a new SysctlConfig.
    /// </summary>
    public SysctlConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SysctlConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _netCoreSomaxconn = DefineProperty<int>("NetCoreSomaxconn", ["netCoreSomaxconn"]);
        _netCoreNetdevMaxBacklog = DefineProperty<int>("NetCoreNetdevMaxBacklog", ["netCoreNetdevMaxBacklog"]);
        _netCoreRmemDefault = DefineProperty<int>("NetCoreRmemDefault", ["netCoreRmemDefault"]);
        _netCoreRmemMax = DefineProperty<int>("NetCoreRmemMax", ["netCoreRmemMax"]);
        _netCoreWmemDefault = DefineProperty<int>("NetCoreWmemDefault", ["netCoreWmemDefault"]);
        _netCoreWmemMax = DefineProperty<int>("NetCoreWmemMax", ["netCoreWmemMax"]);
        _netCoreOptmemMax = DefineProperty<int>("NetCoreOptmemMax", ["netCoreOptmemMax"]);
        _netIPv4TcpMaxSynBacklog = DefineProperty<int>("NetIPv4TcpMaxSynBacklog", ["netIpv4TcpMaxSynBacklog"]);
        _netIPv4TcpMaxTwBuckets = DefineProperty<int>("NetIPv4TcpMaxTwBuckets", ["netIpv4TcpMaxTwBuckets"]);
        _netIPv4TcpFinTimeout = DefineProperty<int>("NetIPv4TcpFinTimeout", ["netIpv4TcpFinTimeout"]);
        _netIPv4TcpKeepaliveTime = DefineProperty<int>("NetIPv4TcpKeepaliveTime", ["netIpv4TcpKeepaliveTime"]);
        _netIPv4TcpKeepaliveProbes = DefineProperty<int>("NetIPv4TcpKeepaliveProbes", ["netIpv4TcpKeepaliveProbes"]);
        _netIPv4TcpKeepaliveIntvl = DefineProperty<int>("NetIPv4TcpKeepaliveIntvl", ["netIpv4TcpkeepaliveIntvl"]);
        _netIPv4TcpTwReuse = DefineProperty<bool>("NetIPv4TcpTwReuse", ["netIpv4TcpTwReuse"]);
        _netIPv4IPLocalPortRange = DefineProperty<string>("NetIPv4IPLocalPortRange", ["netIpv4IpLocalPortRange"]);
        _netIPv4NeighDefaultGcThresh1 = DefineProperty<int>("NetIPv4NeighDefaultGcThresh1", ["netIpv4NeighDefaultGcThresh1"]);
        _netIPv4NeighDefaultGcThresh2 = DefineProperty<int>("NetIPv4NeighDefaultGcThresh2", ["netIpv4NeighDefaultGcThresh2"]);
        _netIPv4NeighDefaultGcThresh3 = DefineProperty<int>("NetIPv4NeighDefaultGcThresh3", ["netIpv4NeighDefaultGcThresh3"]);
        _netNetfilterNfConntrackMax = DefineProperty<int>("NetNetfilterNfConntrackMax", ["netNetfilterNfConntrackMax"]);
        _netNetfilterNfConntrackBuckets = DefineProperty<int>("NetNetfilterNfConntrackBuckets", ["netNetfilterNfConntrackBuckets"]);
        _fsInotifyMaxUserWatches = DefineProperty<int>("FsInotifyMaxUserWatches", ["fsInotifyMaxUserWatches"]);
        _fsFileMax = DefineProperty<int>("FsFileMax", ["fsFileMax"]);
        _fsAioMaxNr = DefineProperty<int>("FsAioMaxNr", ["fsAioMaxNr"]);
        _fsNrOpen = DefineProperty<int>("FsNrOpen", ["fsNrOpen"]);
        _kernelThreadsMax = DefineProperty<int>("KernelThreadsMax", ["kernelThreadsMax"]);
        _vmMaxMapCount = DefineProperty<int>("VmMaxMapCount", ["vmMaxMapCount"]);
        _vmSwappiness = DefineProperty<int>("VmSwappiness", ["vmSwappiness"]);
        _vmVfsCachePressure = DefineProperty<int>("VmVfsCachePressure", ["vmVfsCachePressure"]);
    }
}
