// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Storage profile for the container service cluster.
/// </summary>
public partial class ManagedClusterStorageProfile : ProvisionableConstruct
{
    /// <summary>
    /// Whether to enable AzureDisk CSI Driver. The default value is true.
    /// </summary>
    public BicepValue<bool> IsDiskCsiDriverEnabled 
    {
        get { Initialize(); return _isDiskCsiDriverEnabled!; }
        set { Initialize(); _isDiskCsiDriverEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isDiskCsiDriverEnabled;

    /// <summary>
    /// Whether to enable AzureFile CSI Driver. The default value is true.
    /// </summary>
    public BicepValue<bool> IsFileCsiDriverEnabled 
    {
        get { Initialize(); return _isFileCsiDriverEnabled!; }
        set { Initialize(); _isFileCsiDriverEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isFileCsiDriverEnabled;

    /// <summary>
    /// Whether to enable Snapshot Controller. The default value is true.
    /// </summary>
    public BicepValue<bool> IsSnapshotControllerEnabled 
    {
        get { Initialize(); return _isSnapshotControllerEnabled!; }
        set { Initialize(); _isSnapshotControllerEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isSnapshotControllerEnabled;

    /// <summary>
    /// Whether to enable AzureBlob CSI Driver. The default value is false.
    /// </summary>
    public BicepValue<bool> IsBlobCsiDriverEnabled 
    {
        get { Initialize(); return _isBlobCsiDriverEnabled!; }
        set { Initialize(); _isBlobCsiDriverEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isBlobCsiDriverEnabled;

    /// <summary>
    /// Creates a new ManagedClusterStorageProfile.
    /// </summary>
    public ManagedClusterStorageProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedClusterStorageProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isDiskCsiDriverEnabled = DefineProperty<bool>("IsDiskCsiDriverEnabled", ["diskCSIDriver"]);
        _isFileCsiDriverEnabled = DefineProperty<bool>("IsFileCsiDriverEnabled", ["fileCSIDriver"]);
        _isSnapshotControllerEnabled = DefineProperty<bool>("IsSnapshotControllerEnabled", ["snapshotController"]);
        _isBlobCsiDriverEnabled = DefineProperty<bool>("IsBlobCsiDriverEnabled", ["blobCSIDriver"]);
    }
}
