// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// If not specified, the default is &apos;Free&apos;. See [uptime
/// SLA](https://docs.microsoft.com/azure/aks/uptime-sla) for more details.
/// </summary>
public enum ManagedClusterSkuTier
{
    /// <summary>
    /// Guarantees 99.95% availability of the Kubernetes API server endpoint
    /// for clusters that use Availability Zones and 99.9% of availability for
    /// clusters that don&apos;t use Availability Zones.
    /// </summary>
    Paid,

    /// <summary>
    /// Cluster has premium capabilities in addition to all of the capabilities
    /// included in &apos;Standard&apos;. Premium enables selection of
    /// LongTermSupport (aka.ms/aks/lts) for certain Kubernetes versions.
    /// </summary>
    Premium,

    /// <summary>
    /// Recommended for mission-critical and production workloads. Includes
    /// Kubernetes control plane autoscaling, workload-intensive testing, and
    /// up to 5,000 nodes per cluster. Guarantees 99.95% availability of the
    /// Kubernetes API server endpoint for clusters that use Availability
    /// Zones and 99.9% of availability for clusters that don&apos;t use
    /// Availability Zones.
    /// </summary>
    Standard,

    /// <summary>
    /// The cluster management is free, but charged for VM, storage, and
    /// networking usage. Best for experimenting, learning, simple testing, or
    /// workloads with fewer than 10 nodes. Not recommended for production use
    /// cases.
    /// </summary>
    Free,
}
