// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// The SKU of a Managed Cluster.
/// </summary>
public partial class ManagedClusterSku : ProvisionableConstruct
{
    /// <summary>
    /// The name of a managed cluster SKU.
    /// </summary>
    public BicepValue<ManagedClusterSkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<ManagedClusterSkuName>? _name;

    /// <summary>
    /// If not specified, the default is &apos;Free&apos;. See [AKS Pricing
    /// Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers)
    /// for more details.
    /// </summary>
    public BicepValue<ManagedClusterSkuTier> Tier 
    {
        get { Initialize(); return _tier!; }
        set { Initialize(); _tier!.Assign(value); }
    }
    private BicepValue<ManagedClusterSkuTier>? _tier;

    /// <summary>
    /// Creates a new ManagedClusterSku.
    /// </summary>
    public ManagedClusterSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedClusterSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<ManagedClusterSkuName>("Name", ["name"]);
        _tier = DefineProperty<ManagedClusterSkuTier>("Tier", ["tier"]);
    }
}
