// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Information about a service principal identity for the cluster to use for
/// manipulating Azure APIs.
/// </summary>
public partial class ManagedClusterServicePrincipalProfile : ProvisionableConstruct
{
    /// <summary>
    /// The ID for the service principal.
    /// </summary>
    public BicepValue<string> ClientId 
    {
        get { Initialize(); return _clientId!; }
        set { Initialize(); _clientId!.Assign(value); }
    }
    private BicepValue<string>? _clientId;

    /// <summary>
    /// The secret password associated with the service principal in plain text.
    /// </summary>
    public BicepValue<string> Secret 
    {
        get { Initialize(); return _secret!; }
        set { Initialize(); _secret!.Assign(value); }
    }
    private BicepValue<string>? _secret;

    /// <summary>
    /// Creates a new ManagedClusterServicePrincipalProfile.
    /// </summary>
    public ManagedClusterServicePrincipalProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterServicePrincipalProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _clientId = DefineProperty<string>("ClientId", ["clientId"]);
        _secret = DefineProperty<string>("Secret", ["secret"]);
    }
}
