// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Image Cleaner removes unused images from nodes, freeing up disk space and
/// helping to reduce attack surface area. Here are settings for the security
/// profile.
/// </summary>
public partial class ManagedClusterSecurityProfileImageCleaner : ProvisionableConstruct
{
    /// <summary>
    /// Whether to enable Image Cleaner on AKS cluster.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Image Cleaner scanning interval in hours.
    /// </summary>
    public BicepValue<int> IntervalHours 
    {
        get { Initialize(); return _intervalHours!; }
        set { Initialize(); _intervalHours!.Assign(value); }
    }
    private BicepValue<int>? _intervalHours;

    /// <summary>
    /// Creates a new ManagedClusterSecurityProfileImageCleaner.
    /// </summary>
    public ManagedClusterSecurityProfileImageCleaner()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterSecurityProfileImageCleaner.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _intervalHours = DefineProperty<int>("IntervalHours", ["intervalHours"]);
    }
}
