// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Microsoft Defender settings for the security profile.
/// </summary>
public partial class ManagedClusterSecurityProfileDefender : ProvisionableConstruct
{
    /// <summary>
    /// Resource ID of the Log Analytics workspace to be associated with
    /// Microsoft Defender. When Microsoft Defender is enabled, this field is
    /// required and must be a valid workspace resource ID. When Microsoft
    /// Defender is disabled, leave the field empty.
    /// </summary>
    public BicepValue<ResourceIdentifier> LogAnalyticsWorkspaceResourceId 
    {
        get { Initialize(); return _logAnalyticsWorkspaceResourceId!; }
        set { Initialize(); _logAnalyticsWorkspaceResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _logAnalyticsWorkspaceResourceId;

    /// <summary>
    /// Whether to enable Defender threat detection.
    /// </summary>
    public BicepValue<bool> IsSecurityMonitoringEnabled 
    {
        get { Initialize(); return _isSecurityMonitoringEnabled!; }
        set { Initialize(); _isSecurityMonitoringEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isSecurityMonitoringEnabled;

    /// <summary>
    /// Creates a new ManagedClusterSecurityProfileDefender.
    /// </summary>
    public ManagedClusterSecurityProfileDefender()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterSecurityProfileDefender.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _logAnalyticsWorkspaceResourceId = DefineProperty<ResourceIdentifier>("LogAnalyticsWorkspaceResourceId", ["logAnalyticsWorkspaceResourceId"]);
        _isSecurityMonitoringEnabled = DefineProperty<bool>("IsSecurityMonitoringEnabled", ["securityMonitoring", "enabled"]);
    }
}
