// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// See [use AAD pod
/// identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity)
/// for more details on pod identity integration.
/// </summary>
public partial class ManagedClusterPodIdentityProfile : ProvisionableConstruct
{
    /// <summary>
    /// Whether the pod identity addon is enabled.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Running in Kubenet is disabled by default due to the security related
    /// nature of AAD Pod Identity and the risks of IP spoofing. See [using
    /// Kubenet network plugin with AAD Pod
    /// Identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities)
    /// for more information.
    /// </summary>
    public BicepValue<bool> AllowNetworkPluginKubenet 
    {
        get { Initialize(); return _allowNetworkPluginKubenet!; }
        set { Initialize(); _allowNetworkPluginKubenet!.Assign(value); }
    }
    private BicepValue<bool>? _allowNetworkPluginKubenet;

    /// <summary>
    /// The pod identities to use in the cluster.
    /// </summary>
    public BicepList<ManagedClusterPodIdentity> UserAssignedIdentities 
    {
        get { Initialize(); return _userAssignedIdentities!; }
        set { Initialize(); _userAssignedIdentities!.Assign(value); }
    }
    private BicepList<ManagedClusterPodIdentity>? _userAssignedIdentities;

    /// <summary>
    /// The pod identity exceptions to allow.
    /// </summary>
    public BicepList<ManagedClusterPodIdentityException> UserAssignedIdentityExceptions 
    {
        get { Initialize(); return _userAssignedIdentityExceptions!; }
        set { Initialize(); _userAssignedIdentityExceptions!.Assign(value); }
    }
    private BicepList<ManagedClusterPodIdentityException>? _userAssignedIdentityExceptions;

    /// <summary>
    /// Creates a new ManagedClusterPodIdentityProfile.
    /// </summary>
    public ManagedClusterPodIdentityProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterPodIdentityProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _allowNetworkPluginKubenet = DefineProperty<bool>("AllowNetworkPluginKubenet", ["allowNetworkPluginKubenet"]);
        _userAssignedIdentities = DefineListProperty<ManagedClusterPodIdentity>("UserAssignedIdentities", ["userAssignedIdentities"]);
        _userAssignedIdentityExceptions = DefineListProperty<ManagedClusterPodIdentityException>("UserAssignedIdentityExceptions", ["userAssignedIdentityExceptions"]);
    }
}
