// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// See [disable AAD Pod Identity for a specific
/// Pod/Application](https://azure.github.io/aad-pod-identity/docs/configure/application_exception/)
/// for more details.
/// </summary>
public partial class ManagedClusterPodIdentityException : ProvisionableConstruct
{
    /// <summary>
    /// The name of the pod identity exception.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The namespace of the pod identity exception.
    /// </summary>
    public BicepValue<string> Namespace 
    {
        get { Initialize(); return _namespace!; }
        set { Initialize(); _namespace!.Assign(value); }
    }
    private BicepValue<string>? _namespace;

    /// <summary>
    /// The pod labels to match.
    /// </summary>
    public BicepDictionary<string> PodLabels 
    {
        get { Initialize(); return _podLabels!; }
        set { Initialize(); _podLabels!.Assign(value); }
    }
    private BicepDictionary<string>? _podLabels;

    /// <summary>
    /// Creates a new ManagedClusterPodIdentityException.
    /// </summary>
    public ManagedClusterPodIdentityException()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterPodIdentityException.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _namespace = DefineProperty<string>("Namespace", ["namespace"]);
        _podLabels = DefineDictionaryProperty<string>("PodLabels", ["podLabels"]);
    }
}
