// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Details about the pod identity assigned to the Managed Cluster.
/// </summary>
public partial class ManagedClusterPodIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The name of the pod identity.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The namespace of the pod identity.
    /// </summary>
    public BicepValue<string> Namespace 
    {
        get { Initialize(); return _namespace!; }
        set { Initialize(); _namespace!.Assign(value); }
    }
    private BicepValue<string>? _namespace;

    /// <summary>
    /// The binding selector to use for the AzureIdentityBinding resource.
    /// </summary>
    public BicepValue<string> BindingSelector 
    {
        get { Initialize(); return _bindingSelector!; }
        set { Initialize(); _bindingSelector!.Assign(value); }
    }
    private BicepValue<string>? _bindingSelector;

    /// <summary>
    /// The user assigned identity details.
    /// </summary>
    public ContainerServiceUserAssignedIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ContainerServiceUserAssignedIdentity? _identity;

    /// <summary>
    /// The current provisioning state of the pod identity.
    /// </summary>
    public BicepValue<ManagedClusterPodIdentityProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ManagedClusterPodIdentityProvisioningState>? _provisioningState;

    /// <summary>
    /// Details about the error.
    /// </summary>
    public BicepValue<ResponseError> ErrorDetail 
    {
        get { Initialize(); return _errorDetail!; }
    }
    private BicepValue<ResponseError>? _errorDetail;

    /// <summary>
    /// Creates a new ManagedClusterPodIdentity.
    /// </summary>
    public ManagedClusterPodIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedClusterPodIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _namespace = DefineProperty<string>("Namespace", ["namespace"]);
        _bindingSelector = DefineProperty<string>("BindingSelector", ["bindingSelector"]);
        _identity = DefineModelProperty<ContainerServiceUserAssignedIdentity>("Identity", ["identity"]);
        _provisioningState = DefineProperty<ManagedClusterPodIdentityProvisioningState>("ProvisioningState", ["provisioningState"], isOutput: true);
        _errorDetail = DefineProperty<ResponseError>("ErrorDetail", ["provisioningInfo", "error", "error"], isOutput: true);
    }
}
