// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// The OIDC issuer profile of the Managed Cluster.
/// </summary>
public partial class ManagedClusterOidcIssuerProfile : ProvisionableConstruct
{
    /// <summary>
    /// The OIDC issuer url of the Managed Cluster.
    /// </summary>
    public BicepValue<string> IssuerUriInfo 
    {
        get { Initialize(); return _issuerUriInfo!; }
    }
    private BicepValue<string>? _issuerUriInfo;

    /// <summary>
    /// Whether the OIDC issuer is enabled.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Creates a new ManagedClusterOidcIssuerProfile.
    /// </summary>
    public ManagedClusterOidcIssuerProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterOidcIssuerProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _issuerUriInfo = DefineProperty<string>("IssuerUriInfo", ["issuerURL"], isOutput: true);
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
    }
}
