// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Manner in which the OS on your nodes is updated. The default is NodeImage.
/// </summary>
public enum ManagedClusterNodeOSUpgradeChannel
{
    /// <summary>
    /// No attempt to update your machines OS will be made either by OS or by
    /// rolling VHDs. This means you are responsible for your security updates.
    /// </summary>
    None,

    /// <summary>
    /// OS updates will be applied automatically through the OS built-in
    /// patching infrastructure. Newly scaled in machines will be unpatched
    /// initially and will be patched at some point by the OS&apos;s
    /// infrastructure. Behavior of this option depends on the OS in question.
    /// Ubuntu and Mariner apply security patches through unattended upgrade
    /// roughly once a day around 06:00 UTC. Windows does not apply security
    /// patches automatically and so for them this option is equivalent to
    /// None till further notice.
    /// </summary>
    Unmanaged,

    /// <summary>
    /// AKS will update the nodes with a newly patched VHD containing security
    /// fixes and bugfixes on a weekly cadence. With the VHD update machines
    /// will be rolling reimaged to that VHD following maintenance windows and
    /// surge settings. No extra VHD cost is incurred when choosing this
    /// option as AKS hosts the images.
    /// </summary>
    NodeImage,
}
