// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Metrics profile for the Azure Monitor managed service for Prometheus addon.
/// Collect out-of-the-box Kubernetes infrastructure metrics to send to an
/// Azure Monitor Workspace and configure additional scraping for custom
/// targets. See aka.ms/AzureManagedPrometheus for an overview.
/// </summary>
public partial class ManagedClusterMonitorProfileMetrics : ProvisionableConstruct
{
    /// <summary>
    /// Whether to enable or disable the Azure Managed Prometheus addon for
    /// Prometheus monitoring. See aka.ms/AzureManagedPrometheus-aks-enable
    /// for details on enabling and disabling.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Kube State Metrics profile for the Azure Managed Prometheus addon.
    /// These optional settings are for the kube-state-metrics pod that is
    /// deployed with the addon. See
    /// aka.ms/AzureManagedPrometheus-optional-parameters for details.
    /// </summary>
    public ManagedClusterMonitorProfileKubeStateMetrics KubeStateMetrics 
    {
        get { Initialize(); return _kubeStateMetrics!; }
        set { Initialize(); AssignOrReplace(ref _kubeStateMetrics, value); }
    }
    private ManagedClusterMonitorProfileKubeStateMetrics? _kubeStateMetrics;

    /// <summary>
    /// Creates a new ManagedClusterMonitorProfileMetrics.
    /// </summary>
    public ManagedClusterMonitorProfileMetrics()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterMonitorProfileMetrics.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _kubeStateMetrics = DefineModelProperty<ManagedClusterMonitorProfileKubeStateMetrics>("KubeStateMetrics", ["kubeStateMetrics"]);
    }
}
