// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Profile of the managed cluster load balancer.
/// </summary>
public partial class ManagedClusterLoadBalancerProfile : ProvisionableConstruct
{
    /// <summary>
    /// Desired managed outbound IPs for the cluster load balancer.
    /// </summary>
    public ManagedClusterLoadBalancerProfileManagedOutboundIPs ManagedOutboundIPs 
    {
        get { Initialize(); return _managedOutboundIPs!; }
        set { Initialize(); AssignOrReplace(ref _managedOutboundIPs, value); }
    }
    private ManagedClusterLoadBalancerProfileManagedOutboundIPs? _managedOutboundIPs;

    /// <summary>
    /// A list of public IP prefix resources.
    /// </summary>
    public BicepList<WritableSubResource> OutboundPublicIPPrefixes 
    {
        get { Initialize(); return _outboundPublicIPPrefixes!; }
        set { Initialize(); _outboundPublicIPPrefixes!.Assign(value); }
    }
    private BicepList<WritableSubResource>? _outboundPublicIPPrefixes;

    /// <summary>
    /// A list of public IP resources.
    /// </summary>
    public BicepList<WritableSubResource> OutboundPublicIPs 
    {
        get { Initialize(); return _outboundPublicIPs!; }
        set { Initialize(); _outboundPublicIPs!.Assign(value); }
    }
    private BicepList<WritableSubResource>? _outboundPublicIPs;

    /// <summary>
    /// The effective outbound IP resources of the cluster load balancer.
    /// </summary>
    public BicepList<WritableSubResource> EffectiveOutboundIPs 
    {
        get { Initialize(); return _effectiveOutboundIPs!; }
        set { Initialize(); _effectiveOutboundIPs!.Assign(value); }
    }
    private BicepList<WritableSubResource>? _effectiveOutboundIPs;

    /// <summary>
    /// The desired number of allocated SNAT ports per VM. Allowed values are
    /// in the range of 0 to 64000 (inclusive). The default value is 0 which
    /// results in Azure dynamically allocating ports.
    /// </summary>
    public BicepValue<int> AllocatedOutboundPorts 
    {
        get { Initialize(); return _allocatedOutboundPorts!; }
        set { Initialize(); _allocatedOutboundPorts!.Assign(value); }
    }
    private BicepValue<int>? _allocatedOutboundPorts;

    /// <summary>
    /// Desired outbound flow idle timeout in minutes. Allowed values are in
    /// the range of 4 to 120 (inclusive). The default value is 30 minutes.
    /// </summary>
    public BicepValue<int> IdleTimeoutInMinutes 
    {
        get { Initialize(); return _idleTimeoutInMinutes!; }
        set { Initialize(); _idleTimeoutInMinutes!.Assign(value); }
    }
    private BicepValue<int>? _idleTimeoutInMinutes;

    /// <summary>
    /// Enable multiple standard load balancers per AKS cluster or not.
    /// </summary>
    public BicepValue<bool> EnableMultipleStandardLoadBalancers 
    {
        get { Initialize(); return _enableMultipleStandardLoadBalancers!; }
        set { Initialize(); _enableMultipleStandardLoadBalancers!.Assign(value); }
    }
    private BicepValue<bool>? _enableMultipleStandardLoadBalancers;

    /// <summary>
    /// The type of the managed inbound Load Balancer BackendPool.
    /// </summary>
    public BicepValue<ManagedClusterLoadBalancerBackendPoolType> BackendPoolType 
    {
        get { Initialize(); return _backendPoolType!; }
        set { Initialize(); _backendPoolType!.Assign(value); }
    }
    private BicepValue<ManagedClusterLoadBalancerBackendPoolType>? _backendPoolType;

    /// <summary>
    /// Creates a new ManagedClusterLoadBalancerProfile.
    /// </summary>
    public ManagedClusterLoadBalancerProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterLoadBalancerProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _managedOutboundIPs = DefineModelProperty<ManagedClusterLoadBalancerProfileManagedOutboundIPs>("ManagedOutboundIPs", ["managedOutboundIPs"]);
        _outboundPublicIPPrefixes = DefineListProperty<WritableSubResource>("OutboundPublicIPPrefixes", ["outboundIPPrefixes", "publicIPPrefixes"]);
        _outboundPublicIPs = DefineListProperty<WritableSubResource>("OutboundPublicIPs", ["outboundIPs", "publicIPs"]);
        _effectiveOutboundIPs = DefineListProperty<WritableSubResource>("EffectiveOutboundIPs", ["effectiveOutboundIPs"]);
        _allocatedOutboundPorts = DefineProperty<int>("AllocatedOutboundPorts", ["allocatedOutboundPorts"]);
        _idleTimeoutInMinutes = DefineProperty<int>("IdleTimeoutInMinutes", ["idleTimeoutInMinutes"]);
        _enableMultipleStandardLoadBalancers = DefineProperty<bool>("EnableMultipleStandardLoadBalancers", ["enableMultipleStandardLoadBalancers"]);
        _backendPoolType = DefineProperty<ManagedClusterLoadBalancerBackendPoolType>("BackendPoolType", ["backendPoolType"]);
    }
}
