// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Auto upgrade profile for a managed cluster.
/// </summary>
public partial class ManagedClusterAutoUpgradeProfile : ProvisionableConstruct
{
    /// <summary>
    /// For more information see [setting the AKS cluster auto-upgrade
    /// channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
    /// </summary>
    public BicepValue<UpgradeChannel> UpgradeChannel 
    {
        get { Initialize(); return _upgradeChannel!; }
        set { Initialize(); _upgradeChannel!.Assign(value); }
    }
    private BicepValue<UpgradeChannel>? _upgradeChannel;

    /// <summary>
    /// Manner in which the OS on your nodes is updated. The default is
    /// NodeImage.
    /// </summary>
    public BicepValue<ManagedClusterNodeOSUpgradeChannel> NodeOSUpgradeChannel 
    {
        get { Initialize(); return _nodeOSUpgradeChannel!; }
        set { Initialize(); _nodeOSUpgradeChannel!.Assign(value); }
    }
    private BicepValue<ManagedClusterNodeOSUpgradeChannel>? _nodeOSUpgradeChannel;

    /// <summary>
    /// Creates a new ManagedClusterAutoUpgradeProfile.
    /// </summary>
    public ManagedClusterAutoUpgradeProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterAutoUpgradeProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _upgradeChannel = DefineProperty<UpgradeChannel>("UpgradeChannel", ["upgradeChannel"]);
        _nodeOSUpgradeChannel = DefineProperty<ManagedClusterNodeOSUpgradeChannel>("NodeOSUpgradeChannel", ["nodeOSUpgradeChannel"]);
    }
}
