// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Parameters to be applied to the cluster-autoscaler when enabled.
/// </summary>
public partial class ManagedClusterAutoScalerProfile : ProvisionableConstruct
{
    /// <summary>
    /// Valid values are &apos;true&apos; and &apos;false&apos;.
    /// </summary>
    public BicepValue<string> BalanceSimilarNodeGroups 
    {
        get { Initialize(); return _balanceSimilarNodeGroups!; }
        set { Initialize(); _balanceSimilarNodeGroups!.Assign(value); }
    }
    private BicepValue<string>? _balanceSimilarNodeGroups;

    /// <summary>
    /// If not specified, the default is &apos;random&apos;. See
    /// [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders)
    /// for more information.
    /// </summary>
    public BicepValue<AutoScaleExpander> Expander 
    {
        get { Initialize(); return _expander!; }
        set { Initialize(); _expander!.Assign(value); }
    }
    private BicepValue<AutoScaleExpander>? _expander;

    /// <summary>
    /// The default is 10.
    /// </summary>
    public BicepValue<string> MaxEmptyBulkDelete 
    {
        get { Initialize(); return _maxEmptyBulkDelete!; }
        set { Initialize(); _maxEmptyBulkDelete!.Assign(value); }
    }
    private BicepValue<string>? _maxEmptyBulkDelete;

    /// <summary>
    /// The default is 600.
    /// </summary>
    public BicepValue<string> MaxGracefulTerminationSec 
    {
        get { Initialize(); return _maxGracefulTerminationSec!; }
        set { Initialize(); _maxGracefulTerminationSec!.Assign(value); }
    }
    private BicepValue<string>? _maxGracefulTerminationSec;

    /// <summary>
    /// The default is &apos;15m&apos;. Values must be an integer followed by
    /// an &apos;m&apos;. No unit of time other than minutes (m) is supported.
    /// </summary>
    public BicepValue<string> MaxNodeProvisionTime 
    {
        get { Initialize(); return _maxNodeProvisionTime!; }
        set { Initialize(); _maxNodeProvisionTime!.Assign(value); }
    }
    private BicepValue<string>? _maxNodeProvisionTime;

    /// <summary>
    /// The default is 45. The maximum is 100 and the minimum is 0.
    /// </summary>
    public BicepValue<string> MaxTotalUnreadyPercentage 
    {
        get { Initialize(); return _maxTotalUnreadyPercentage!; }
        set { Initialize(); _maxTotalUnreadyPercentage!.Assign(value); }
    }
    private BicepValue<string>? _maxTotalUnreadyPercentage;

    /// <summary>
    /// For scenarios like burst/batch scale where you don&apos;t want CA to
    /// act before the kubernetes scheduler could schedule all the pods, you
    /// can tell CA to ignore unscheduled pods before they&apos;re a certain
    /// age. The default is &apos;0s&apos;. Values must be an integer followed
    /// by a unit (&apos;s&apos; for seconds, &apos;m&apos; for minutes,
    /// &apos;h&apos; for hours, etc).
    /// </summary>
    public BicepValue<string> NewPodScaleUpDelay 
    {
        get { Initialize(); return _newPodScaleUpDelay!; }
        set { Initialize(); _newPodScaleUpDelay!.Assign(value); }
    }
    private BicepValue<string>? _newPodScaleUpDelay;

    /// <summary>
    /// This must be an integer. The default is 3.
    /// </summary>
    public BicepValue<string> OkTotalUnreadyCount 
    {
        get { Initialize(); return _okTotalUnreadyCount!; }
        set { Initialize(); _okTotalUnreadyCount!.Assign(value); }
    }
    private BicepValue<string>? _okTotalUnreadyCount;

    /// <summary>
    /// The default is &apos;10&apos;. Values must be an integer number of
    /// seconds.
    /// </summary>
    public BicepValue<string> ScanIntervalInSeconds 
    {
        get { Initialize(); return _scanIntervalInSeconds!; }
        set { Initialize(); _scanIntervalInSeconds!.Assign(value); }
    }
    private BicepValue<string>? _scanIntervalInSeconds;

    /// <summary>
    /// The default is &apos;10m&apos;. Values must be an integer followed by
    /// an &apos;m&apos;. No unit of time other than minutes (m) is supported.
    /// </summary>
    public BicepValue<string> ScaleDownDelayAfterAdd 
    {
        get { Initialize(); return _scaleDownDelayAfterAdd!; }
        set { Initialize(); _scaleDownDelayAfterAdd!.Assign(value); }
    }
    private BicepValue<string>? _scaleDownDelayAfterAdd;

    /// <summary>
    /// The default is the scan-interval. Values must be an integer followed by
    /// an &apos;m&apos;. No unit of time other than minutes (m) is supported.
    /// </summary>
    public BicepValue<string> ScaleDownDelayAfterDelete 
    {
        get { Initialize(); return _scaleDownDelayAfterDelete!; }
        set { Initialize(); _scaleDownDelayAfterDelete!.Assign(value); }
    }
    private BicepValue<string>? _scaleDownDelayAfterDelete;

    /// <summary>
    /// The default is &apos;3m&apos;. Values must be an integer followed by an
    /// &apos;m&apos;. No unit of time other than minutes (m) is supported.
    /// </summary>
    public BicepValue<string> ScaleDownDelayAfterFailure 
    {
        get { Initialize(); return _scaleDownDelayAfterFailure!; }
        set { Initialize(); _scaleDownDelayAfterFailure!.Assign(value); }
    }
    private BicepValue<string>? _scaleDownDelayAfterFailure;

    /// <summary>
    /// The default is &apos;10m&apos;. Values must be an integer followed by
    /// an &apos;m&apos;. No unit of time other than minutes (m) is supported.
    /// </summary>
    public BicepValue<string> ScaleDownUnneededTime 
    {
        get { Initialize(); return _scaleDownUnneededTime!; }
        set { Initialize(); _scaleDownUnneededTime!.Assign(value); }
    }
    private BicepValue<string>? _scaleDownUnneededTime;

    /// <summary>
    /// The default is &apos;20m&apos;. Values must be an integer followed by
    /// an &apos;m&apos;. No unit of time other than minutes (m) is supported.
    /// </summary>
    public BicepValue<string> ScaleDownUnreadyTime 
    {
        get { Initialize(); return _scaleDownUnreadyTime!; }
        set { Initialize(); _scaleDownUnreadyTime!.Assign(value); }
    }
    private BicepValue<string>? _scaleDownUnreadyTime;

    /// <summary>
    /// The default is &apos;0.5&apos;.
    /// </summary>
    public BicepValue<string> ScaleDownUtilizationThreshold 
    {
        get { Initialize(); return _scaleDownUtilizationThreshold!; }
        set { Initialize(); _scaleDownUtilizationThreshold!.Assign(value); }
    }
    private BicepValue<string>? _scaleDownUtilizationThreshold;

    /// <summary>
    /// The default is true.
    /// </summary>
    public BicepValue<string> SkipNodesWithLocalStorage 
    {
        get { Initialize(); return _skipNodesWithLocalStorage!; }
        set { Initialize(); _skipNodesWithLocalStorage!.Assign(value); }
    }
    private BicepValue<string>? _skipNodesWithLocalStorage;

    /// <summary>
    /// The default is true.
    /// </summary>
    public BicepValue<string> SkipNodesWithSystemPods 
    {
        get { Initialize(); return _skipNodesWithSystemPods!; }
        set { Initialize(); _skipNodesWithSystemPods!.Assign(value); }
    }
    private BicepValue<string>? _skipNodesWithSystemPods;

    /// <summary>
    /// Creates a new ManagedClusterAutoScalerProfile.
    /// </summary>
    public ManagedClusterAutoScalerProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterAutoScalerProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _balanceSimilarNodeGroups = DefineProperty<string>("BalanceSimilarNodeGroups", ["balance-similar-node-groups"]);
        _expander = DefineProperty<AutoScaleExpander>("Expander", ["expander"]);
        _maxEmptyBulkDelete = DefineProperty<string>("MaxEmptyBulkDelete", ["max-empty-bulk-delete"]);
        _maxGracefulTerminationSec = DefineProperty<string>("MaxGracefulTerminationSec", ["max-graceful-termination-sec"]);
        _maxNodeProvisionTime = DefineProperty<string>("MaxNodeProvisionTime", ["max-node-provision-time"]);
        _maxTotalUnreadyPercentage = DefineProperty<string>("MaxTotalUnreadyPercentage", ["max-total-unready-percentage"]);
        _newPodScaleUpDelay = DefineProperty<string>("NewPodScaleUpDelay", ["new-pod-scale-up-delay"]);
        _okTotalUnreadyCount = DefineProperty<string>("OkTotalUnreadyCount", ["ok-total-unready-count"]);
        _scanIntervalInSeconds = DefineProperty<string>("ScanIntervalInSeconds", ["scan-interval"]);
        _scaleDownDelayAfterAdd = DefineProperty<string>("ScaleDownDelayAfterAdd", ["scale-down-delay-after-add"]);
        _scaleDownDelayAfterDelete = DefineProperty<string>("ScaleDownDelayAfterDelete", ["scale-down-delay-after-delete"]);
        _scaleDownDelayAfterFailure = DefineProperty<string>("ScaleDownDelayAfterFailure", ["scale-down-delay-after-failure"]);
        _scaleDownUnneededTime = DefineProperty<string>("ScaleDownUnneededTime", ["scale-down-unneeded-time"]);
        _scaleDownUnreadyTime = DefineProperty<string>("ScaleDownUnreadyTime", ["scale-down-unready-time"]);
        _scaleDownUtilizationThreshold = DefineProperty<string>("ScaleDownUtilizationThreshold", ["scale-down-utilization-threshold"]);
        _skipNodesWithLocalStorage = DefineProperty<string>("SkipNodesWithLocalStorage", ["skip-nodes-with-local-storage"]);
        _skipNodesWithSystemPods = DefineProperty<string>("SkipNodesWithSystemPods", ["skip-nodes-with-system-pods"]);
    }
}
