// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Access profile for managed cluster API server.
/// </summary>
public partial class ManagedClusterApiServerAccessProfile : ProvisionableConstruct
{
    /// <summary>
    /// IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This
    /// feature is not compatible with clusters that use Public IP Per Node,
    /// or clusters that are using a Basic Load Balancer. For more information
    /// see [API server authorized IP
    /// ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
    /// </summary>
    public BicepList<string> AuthorizedIPRanges 
    {
        get { Initialize(); return _authorizedIPRanges!; }
        set { Initialize(); _authorizedIPRanges!.Assign(value); }
    }
    private BicepList<string>? _authorizedIPRanges;

    /// <summary>
    /// For more details, see [Creating a private AKS
    /// cluster](https://docs.microsoft.com/azure/aks/private-clusters).
    /// </summary>
    public BicepValue<bool> EnablePrivateCluster 
    {
        get { Initialize(); return _enablePrivateCluster!; }
        set { Initialize(); _enablePrivateCluster!.Assign(value); }
    }
    private BicepValue<bool>? _enablePrivateCluster;

    /// <summary>
    /// The default is System. For more details see [configure private DNS
    /// zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone).
    /// Allowed values are &apos;system&apos; and &apos;none&apos;.
    /// </summary>
    public BicepValue<string> PrivateDnsZone 
    {
        get { Initialize(); return _privateDnsZone!; }
        set { Initialize(); _privateDnsZone!.Assign(value); }
    }
    private BicepValue<string>? _privateDnsZone;

    /// <summary>
    /// Whether to create additional public FQDN for private cluster or not.
    /// </summary>
    public BicepValue<bool> EnablePrivateClusterPublicFqdn 
    {
        get { Initialize(); return _enablePrivateClusterPublicFqdn!; }
        set { Initialize(); _enablePrivateClusterPublicFqdn!.Assign(value); }
    }
    private BicepValue<bool>? _enablePrivateClusterPublicFqdn;

    /// <summary>
    /// Whether to disable run command for the cluster or not.
    /// </summary>
    public BicepValue<bool> DisableRunCommand 
    {
        get { Initialize(); return _disableRunCommand!; }
        set { Initialize(); _disableRunCommand!.Assign(value); }
    }
    private BicepValue<bool>? _disableRunCommand;

    /// <summary>
    /// Creates a new ManagedClusterApiServerAccessProfile.
    /// </summary>
    public ManagedClusterApiServerAccessProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterApiServerAccessProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _authorizedIPRanges = DefineListProperty<string>("AuthorizedIPRanges", ["authorizedIPRanges"]);
        _enablePrivateCluster = DefineProperty<bool>("EnablePrivateCluster", ["enablePrivateCluster"]);
        _privateDnsZone = DefineProperty<string>("PrivateDnsZone", ["privateDNSZone"]);
        _enablePrivateClusterPublicFqdn = DefineProperty<bool>("EnablePrivateClusterPublicFqdn", ["enablePrivateClusterPublicFQDN"]);
        _disableRunCommand = DefineProperty<bool>("DisableRunCommand", ["disableRunCommand"]);
    }
}
