// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Profile for the container service agent pool.
/// </summary>
public partial class ManagedClusterAgentPoolProfile : ProvisionableConstruct
{
    /// <summary>
    /// Windows agent pool names must be 6 characters or less.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Number of agents (VMs) to host docker containers. Allowed values must
    /// be in the range of 0 to 1000 (inclusive) for user pools and in the
    /// range of 1 to 1000 (inclusive) for system pools. The default value is
    /// 1.
    /// </summary>
    public BicepValue<int> Count 
    {
        get { Initialize(); return _count!; }
        set { Initialize(); _count!.Assign(value); }
    }
    private BicepValue<int>? _count;

    /// <summary>
    /// VM size availability varies by region. If a node contains insufficient
    /// compute resources (memory, cpu, etc) pods might fail to run correctly.
    /// For more details on restricted VM sizes, see:
    /// https://docs.microsoft.com/azure/aks/quotas-skus-regions.
    /// </summary>
    public BicepValue<string> VmSize 
    {
        get { Initialize(); return _vmSize!; }
        set { Initialize(); _vmSize!.Assign(value); }
    }
    private BicepValue<string>? _vmSize;

    /// <summary>
    /// OS Disk Size in GB to be used to specify the disk size for every
    /// machine in the master/agent pool. If you specify 0, it will apply the
    /// default osDisk size according to the vmSize specified.
    /// </summary>
    public BicepValue<int> OSDiskSizeInGB 
    {
        get { Initialize(); return _oSDiskSizeInGB!; }
        set { Initialize(); _oSDiskSizeInGB!.Assign(value); }
    }
    private BicepValue<int>? _oSDiskSizeInGB;

    /// <summary>
    /// The default is &apos;Ephemeral&apos; if the VM supports it and has a
    /// cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults
    /// to &apos;Managed&apos;. May not be changed after creation. For more
    /// information see [Ephemeral
    /// OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
    /// </summary>
    public BicepValue<ContainerServiceOSDiskType> OSDiskType 
    {
        get { Initialize(); return _oSDiskType!; }
        set { Initialize(); _oSDiskType!.Assign(value); }
    }
    private BicepValue<ContainerServiceOSDiskType>? _oSDiskType;

    /// <summary>
    /// Determines the placement of emptyDir volumes, container runtime data
    /// root, and Kubelet ephemeral storage.
    /// </summary>
    public BicepValue<KubeletDiskType> KubeletDiskType 
    {
        get { Initialize(); return _kubeletDiskType!; }
        set { Initialize(); _kubeletDiskType!.Assign(value); }
    }
    private BicepValue<KubeletDiskType>? _kubeletDiskType;

    /// <summary>
    /// Determines the type of workload a node can run.
    /// </summary>
    public BicepValue<WorkloadRuntime> WorkloadRuntime 
    {
        get { Initialize(); return _workloadRuntime!; }
        set { Initialize(); _workloadRuntime!.Assign(value); }
    }
    private BicepValue<WorkloadRuntime>? _workloadRuntime;

    /// <summary>
    /// If this is not specified, a VNET and subnet will be generated and used.
    /// If no podSubnetID is specified, this applies to nodes and pods,
    /// otherwise it applies to just nodes. This is of the form:
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> VnetSubnetId 
    {
        get { Initialize(); return _vnetSubnetId!; }
        set { Initialize(); _vnetSubnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _vnetSubnetId;

    /// <summary>
    /// If omitted, pod IPs are statically assigned on the node subnet (see
    /// vnetSubnetID for more details). This is of the form:
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> PodSubnetId 
    {
        get { Initialize(); return _podSubnetId!; }
        set { Initialize(); _podSubnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _podSubnetId;

    /// <summary>
    /// The maximum number of pods that can run on a node.
    /// </summary>
    public BicepValue<int> MaxPods 
    {
        get { Initialize(); return _maxPods!; }
        set { Initialize(); _maxPods!.Assign(value); }
    }
    private BicepValue<int>? _maxPods;

    /// <summary>
    /// The operating system type. The default is Linux.
    /// </summary>
    public BicepValue<ContainerServiceOSType> OSType 
    {
        get { Initialize(); return _oSType!; }
        set { Initialize(); _oSType!.Assign(value); }
    }
    private BicepValue<ContainerServiceOSType>? _oSType;

    /// <summary>
    /// Specifies the OS SKU used by the agent pool. The default is Ubuntu if
    /// OSType is Linux. The default is Windows2019 when Kubernetes &lt;= 1.24
    /// or Windows2022 when Kubernetes &gt;= 1.25 if OSType is Windows.
    /// </summary>
    public BicepValue<ContainerServiceOSSku> OSSku 
    {
        get { Initialize(); return _oSSku!; }
        set { Initialize(); _oSSku!.Assign(value); }
    }
    private BicepValue<ContainerServiceOSSku>? _oSSku;

    /// <summary>
    /// The maximum number of nodes for auto-scaling.
    /// </summary>
    public BicepValue<int> MaxCount 
    {
        get { Initialize(); return _maxCount!; }
        set { Initialize(); _maxCount!.Assign(value); }
    }
    private BicepValue<int>? _maxCount;

    /// <summary>
    /// The minimum number of nodes for auto-scaling.
    /// </summary>
    public BicepValue<int> MinCount 
    {
        get { Initialize(); return _minCount!; }
        set { Initialize(); _minCount!.Assign(value); }
    }
    private BicepValue<int>? _minCount;

    /// <summary>
    /// Whether to enable auto-scaler.
    /// </summary>
    public BicepValue<bool> EnableAutoScaling 
    {
        get { Initialize(); return _enableAutoScaling!; }
        set { Initialize(); _enableAutoScaling!.Assign(value); }
    }
    private BicepValue<bool>? _enableAutoScaling;

    /// <summary>
    /// This also effects the cluster autoscaler behavior. If not specified, it
    /// defaults to Delete.
    /// </summary>
    public BicepValue<ScaleDownMode> ScaleDownMode 
    {
        get { Initialize(); return _scaleDownMode!; }
        set { Initialize(); _scaleDownMode!.Assign(value); }
    }
    private BicepValue<ScaleDownMode>? _scaleDownMode;

    /// <summary>
    /// The type of Agent Pool.
    /// </summary>
    public BicepValue<AgentPoolType> AgentPoolType 
    {
        get { Initialize(); return _agentPoolType!; }
        set { Initialize(); _agentPoolType!.Assign(value); }
    }
    private BicepValue<AgentPoolType>? _agentPoolType;

    /// <summary>
    /// A cluster must have at least one &apos;System&apos; Agent Pool at all
    /// times. For additional information on agent pool restrictions and best
    /// practices, see: https://docs.microsoft.com/azure/aks/use-system-pools.
    /// </summary>
    public BicepValue<AgentPoolMode> Mode 
    {
        get { Initialize(); return _mode!; }
        set { Initialize(); _mode!.Assign(value); }
    }
    private BicepValue<AgentPoolMode>? _mode;

    /// <summary>
    /// Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and
    /// &lt;major.minor&gt; (e.g. 1.20) are supported. When
    /// &lt;major.minor&gt; is specified, the latest supported GA patch
    /// version is chosen automatically. Updating the cluster with the same
    /// &lt;major.minor&gt; once it has been created (e.g. 1.14.x -&gt; 1.14)
    /// will not trigger an upgrade, even if a newer patch version is
    /// available. As a best practice, you should upgrade all node pools in an
    /// AKS cluster to the same Kubernetes version. The node pool version must
    /// have the same major version as the control plane. The node pool minor
    /// version must be within two minor versions of the control plane
    /// version. The node pool version cannot be greater than the control
    /// plane version. For more information see [upgrading a node
    /// pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
    /// </summary>
    public BicepValue<string> OrchestratorVersion 
    {
        get { Initialize(); return _orchestratorVersion!; }
        set { Initialize(); _orchestratorVersion!.Assign(value); }
    }
    private BicepValue<string>? _orchestratorVersion;

    /// <summary>
    /// If orchestratorVersion is a fully specified version
    /// &lt;major.minor.patch&gt;, this field will be exactly equal to it. If
    /// orchestratorVersion is &lt;major.minor&gt;, this field will contain
    /// the full &lt;major.minor.patch&gt; version being used.
    /// </summary>
    public BicepValue<string> CurrentOrchestratorVersion 
    {
        get { Initialize(); return _currentOrchestratorVersion!; }
    }
    private BicepValue<string>? _currentOrchestratorVersion;

    /// <summary>
    /// The version of node image.
    /// </summary>
    public BicepValue<string> NodeImageVersion 
    {
        get { Initialize(); return _nodeImageVersion!; }
    }
    private BicepValue<string>? _nodeImageVersion;

    /// <summary>
    /// Settings for upgrading the agentpool.
    /// </summary>
    public AgentPoolUpgradeSettings UpgradeSettings 
    {
        get { Initialize(); return _upgradeSettings!; }
        set { Initialize(); AssignOrReplace(ref _upgradeSettings, value); }
    }
    private AgentPoolUpgradeSettings? _upgradeSettings;

    /// <summary>
    /// The current deployment or provisioning state.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// Tells whether the cluster is Running or Stopped.
    /// </summary>
    public BicepValue<ContainerServiceStateCode> PowerStateCode 
    {
        get { Initialize(); return _powerStateCode!; }
        set { Initialize(); _powerStateCode!.Assign(value); }
    }
    private BicepValue<ContainerServiceStateCode>? _powerStateCode;

    /// <summary>
    /// The list of Availability zones to use for nodes. This can only be
    /// specified if the AgentPoolType property is
    /// &apos;VirtualMachineScaleSets&apos;.
    /// </summary>
    public BicepList<string> AvailabilityZones 
    {
        get { Initialize(); return _availabilityZones!; }
        set { Initialize(); _availabilityZones!.Assign(value); }
    }
    private BicepList<string>? _availabilityZones;

    /// <summary>
    /// Some scenarios may require nodes in a node pool to receive their own
    /// dedicated public IP addresses. A common scenario is for gaming
    /// workloads, where a console needs to make a direct connection to a
    /// cloud virtual machine to minimize hops. For more information see
    /// [assigning a public IP per
    /// node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools).
    /// The default is false.
    /// </summary>
    public BicepValue<bool> EnableNodePublicIP 
    {
        get { Initialize(); return _enableNodePublicIP!; }
        set { Initialize(); _enableNodePublicIP!.Assign(value); }
    }
    private BicepValue<bool>? _enableNodePublicIP;

    /// <summary>
    /// This is of the form:
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> NodePublicIPPrefixId 
    {
        get { Initialize(); return _nodePublicIPPrefixId!; }
        set { Initialize(); _nodePublicIPPrefixId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _nodePublicIPPrefixId;

    /// <summary>
    /// The Virtual Machine Scale Set priority. If not specified, the default
    /// is &apos;Regular&apos;.
    /// </summary>
    public BicepValue<ScaleSetPriority> ScaleSetPriority 
    {
        get { Initialize(); return _scaleSetPriority!; }
        set { Initialize(); _scaleSetPriority!.Assign(value); }
    }
    private BicepValue<ScaleSetPriority>? _scaleSetPriority;

    /// <summary>
    /// This cannot be specified unless the scaleSetPriority is
    /// &apos;Spot&apos;. If not specified, the default is &apos;Delete&apos;.
    /// </summary>
    public BicepValue<ScaleSetEvictionPolicy> ScaleSetEvictionPolicy 
    {
        get { Initialize(); return _scaleSetEvictionPolicy!; }
        set { Initialize(); _scaleSetEvictionPolicy!.Assign(value); }
    }
    private BicepValue<ScaleSetEvictionPolicy>? _scaleSetEvictionPolicy;

    /// <summary>
    /// Possible values are any decimal value greater than zero or -1 which
    /// indicates the willingness to pay any on-demand price. For more details
    /// on spot pricing, see [spot VMs
    /// pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing).
    /// </summary>
    public BicepValue<float> SpotMaxPrice 
    {
        get { Initialize(); return _spotMaxPrice!; }
        set { Initialize(); _spotMaxPrice!.Assign(value); }
    }
    private BicepValue<float>? _spotMaxPrice;

    /// <summary>
    /// The tags to be persisted on the agent pool virtual machine scale set.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The node labels to be persisted across all nodes in agent pool.
    /// </summary>
    public BicepDictionary<string> NodeLabels 
    {
        get { Initialize(); return _nodeLabels!; }
        set { Initialize(); _nodeLabels!.Assign(value); }
    }
    private BicepDictionary<string>? _nodeLabels;

    /// <summary>
    /// The taints added to new nodes during node pool create and scale. For
    /// example, key=value:NoSchedule.
    /// </summary>
    public BicepList<string> NodeTaints 
    {
        get { Initialize(); return _nodeTaints!; }
        set { Initialize(); _nodeTaints!.Assign(value); }
    }
    private BicepList<string>? _nodeTaints;

    /// <summary>
    /// The ID for Proximity Placement Group.
    /// </summary>
    public BicepValue<ResourceIdentifier> ProximityPlacementGroupId 
    {
        get { Initialize(); return _proximityPlacementGroupId!; }
        set { Initialize(); _proximityPlacementGroupId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _proximityPlacementGroupId;

    /// <summary>
    /// The Kubelet configuration on the agent pool nodes.
    /// </summary>
    public KubeletConfig KubeletConfig 
    {
        get { Initialize(); return _kubeletConfig!; }
        set { Initialize(); AssignOrReplace(ref _kubeletConfig, value); }
    }
    private KubeletConfig? _kubeletConfig;

    /// <summary>
    /// The OS configuration of Linux agent nodes.
    /// </summary>
    public LinuxOSConfig LinuxOSConfig 
    {
        get { Initialize(); return _linuxOSConfig!; }
        set { Initialize(); AssignOrReplace(ref _linuxOSConfig, value); }
    }
    private LinuxOSConfig? _linuxOSConfig;

    /// <summary>
    /// This is only supported on certain VM sizes and in certain Azure
    /// regions. For more information, see:
    /// https://docs.microsoft.com/azure/aks/enable-host-encryption.
    /// </summary>
    public BicepValue<bool> EnableEncryptionAtHost 
    {
        get { Initialize(); return _enableEncryptionAtHost!; }
        set { Initialize(); _enableEncryptionAtHost!.Assign(value); }
    }
    private BicepValue<bool>? _enableEncryptionAtHost;

    /// <summary>
    /// Whether to enable UltraSSD.
    /// </summary>
    public BicepValue<bool> EnableUltraSsd 
    {
        get { Initialize(); return _enableUltraSsd!; }
        set { Initialize(); _enableUltraSsd!.Assign(value); }
    }
    private BicepValue<bool>? _enableUltraSsd;

    /// <summary>
    /// See [Add a FIPS-enabled node
    /// pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview)
    /// for more details.
    /// </summary>
    public BicepValue<bool> EnableFips 
    {
        get { Initialize(); return _enableFips!; }
        set { Initialize(); _enableFips!.Assign(value); }
    }
    private BicepValue<bool>? _enableFips;

    /// <summary>
    /// GPUInstanceProfile to be used to specify GPU MIG instance profile for
    /// supported GPU VM SKU.
    /// </summary>
    public BicepValue<GpuInstanceProfile> GpuInstanceProfile 
    {
        get { Initialize(); return _gpuInstanceProfile!; }
        set { Initialize(); _gpuInstanceProfile!.Assign(value); }
    }
    private BicepValue<GpuInstanceProfile>? _gpuInstanceProfile;

    /// <summary>
    /// This is the ARM ID of the source object to be used to create the target
    /// object.
    /// </summary>
    public BicepValue<ResourceIdentifier> CreationDataSourceResourceId 
    {
        get { Initialize(); return _creationDataSourceResourceId!; }
        set { Initialize(); _creationDataSourceResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _creationDataSourceResourceId;

    /// <summary>
    /// AKS will associate the specified agent pool with the Capacity
    /// Reservation Group.
    /// </summary>
    public BicepValue<ResourceIdentifier> CapacityReservationGroupId 
    {
        get { Initialize(); return _capacityReservationGroupId!; }
        set { Initialize(); _capacityReservationGroupId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _capacityReservationGroupId;

    /// <summary>
    /// This is of the form:
    /// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
    /// For more information see [Azure dedicated
    /// hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
    /// </summary>
    public BicepValue<ResourceIdentifier> HostGroupId 
    {
        get { Initialize(); return _hostGroupId!; }
        set { Initialize(); _hostGroupId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _hostGroupId;

    /// <summary>
    /// Network-related settings of an agent pool.
    /// </summary>
    public AgentPoolNetworkProfile NetworkProfile 
    {
        get { Initialize(); return _networkProfile!; }
        set { Initialize(); AssignOrReplace(ref _networkProfile, value); }
    }
    private AgentPoolNetworkProfile? _networkProfile;

    /// <summary>
    /// Creates a new ManagedClusterAgentPoolProfile.
    /// </summary>
    public ManagedClusterAgentPoolProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ManagedClusterAgentPoolProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _count = DefineProperty<int>("Count", ["count"]);
        _vmSize = DefineProperty<string>("VmSize", ["vmSize"]);
        _oSDiskSizeInGB = DefineProperty<int>("OSDiskSizeInGB", ["osDiskSizeGB"]);
        _oSDiskType = DefineProperty<ContainerServiceOSDiskType>("OSDiskType", ["osDiskType"]);
        _kubeletDiskType = DefineProperty<KubeletDiskType>("KubeletDiskType", ["kubeletDiskType"]);
        _workloadRuntime = DefineProperty<WorkloadRuntime>("WorkloadRuntime", ["workloadRuntime"]);
        _vnetSubnetId = DefineProperty<ResourceIdentifier>("VnetSubnetId", ["vnetSubnetID"]);
        _podSubnetId = DefineProperty<ResourceIdentifier>("PodSubnetId", ["podSubnetID"]);
        _maxPods = DefineProperty<int>("MaxPods", ["maxPods"]);
        _oSType = DefineProperty<ContainerServiceOSType>("OSType", ["osType"]);
        _oSSku = DefineProperty<ContainerServiceOSSku>("OSSku", ["osSKU"]);
        _maxCount = DefineProperty<int>("MaxCount", ["maxCount"]);
        _minCount = DefineProperty<int>("MinCount", ["minCount"]);
        _enableAutoScaling = DefineProperty<bool>("EnableAutoScaling", ["enableAutoScaling"]);
        _scaleDownMode = DefineProperty<ScaleDownMode>("ScaleDownMode", ["scaleDownMode"]);
        _agentPoolType = DefineProperty<AgentPoolType>("AgentPoolType", ["type"]);
        _mode = DefineProperty<AgentPoolMode>("Mode", ["mode"]);
        _orchestratorVersion = DefineProperty<string>("OrchestratorVersion", ["orchestratorVersion"]);
        _currentOrchestratorVersion = DefineProperty<string>("CurrentOrchestratorVersion", ["currentOrchestratorVersion"], isOutput: true);
        _nodeImageVersion = DefineProperty<string>("NodeImageVersion", ["nodeImageVersion"], isOutput: true);
        _upgradeSettings = DefineModelProperty<AgentPoolUpgradeSettings>("UpgradeSettings", ["upgradeSettings"]);
        _provisioningState = DefineProperty<string>("ProvisioningState", ["provisioningState"], isOutput: true);
        _powerStateCode = DefineProperty<ContainerServiceStateCode>("PowerStateCode", ["powerState", "code"]);
        _availabilityZones = DefineListProperty<string>("AvailabilityZones", ["availabilityZones"]);
        _enableNodePublicIP = DefineProperty<bool>("EnableNodePublicIP", ["enableNodePublicIP"]);
        _nodePublicIPPrefixId = DefineProperty<ResourceIdentifier>("NodePublicIPPrefixId", ["nodePublicIPPrefixID"]);
        _scaleSetPriority = DefineProperty<ScaleSetPriority>("ScaleSetPriority", ["scaleSetPriority"]);
        _scaleSetEvictionPolicy = DefineProperty<ScaleSetEvictionPolicy>("ScaleSetEvictionPolicy", ["scaleSetEvictionPolicy"]);
        _spotMaxPrice = DefineProperty<float>("SpotMaxPrice", ["spotMaxPrice"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _nodeLabels = DefineDictionaryProperty<string>("NodeLabels", ["nodeLabels"]);
        _nodeTaints = DefineListProperty<string>("NodeTaints", ["nodeTaints"]);
        _proximityPlacementGroupId = DefineProperty<ResourceIdentifier>("ProximityPlacementGroupId", ["proximityPlacementGroupID"]);
        _kubeletConfig = DefineModelProperty<KubeletConfig>("KubeletConfig", ["kubeletConfig"]);
        _linuxOSConfig = DefineModelProperty<LinuxOSConfig>("LinuxOSConfig", ["linuxOSConfig"]);
        _enableEncryptionAtHost = DefineProperty<bool>("EnableEncryptionAtHost", ["enableEncryptionAtHost"]);
        _enableUltraSsd = DefineProperty<bool>("EnableUltraSsd", ["enableUltraSSD"]);
        _enableFips = DefineProperty<bool>("EnableFips", ["enableFIPS"]);
        _gpuInstanceProfile = DefineProperty<GpuInstanceProfile>("GpuInstanceProfile", ["gpuInstanceProfile"]);
        _creationDataSourceResourceId = DefineProperty<ResourceIdentifier>("CreationDataSourceResourceId", ["creationData", "sourceResourceId"]);
        _capacityReservationGroupId = DefineProperty<ResourceIdentifier>("CapacityReservationGroupId", ["capacityReservationGroupID"]);
        _hostGroupId = DefineProperty<ResourceIdentifier>("HostGroupId", ["hostGroupID"]);
        _networkProfile = DefineModelProperty<AgentPoolNetworkProfile>("NetworkProfile", ["networkProfile"]);
    }
}
