// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// A Kubernetes add-on profile for a managed cluster.
/// </summary>
public partial class ManagedClusterAddonProfile : ProvisionableConstruct
{
    /// <summary>
    /// Whether the add-on is enabled or not.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Key-value pairs for configuring an add-on.
    /// </summary>
    public BicepDictionary<string> Config 
    {
        get { Initialize(); return _config!; }
        set { Initialize(); _config!.Assign(value); }
    }
    private BicepDictionary<string>? _config;

    /// <summary>
    /// Information of user assigned identity used by this add-on.
    /// </summary>
    public ManagedClusterAddonProfileIdentity Identity 
    {
        get { Initialize(); return _identity!; }
    }
    private ManagedClusterAddonProfileIdentity? _identity;

    /// <summary>
    /// Creates a new ManagedClusterAddonProfile.
    /// </summary>
    public ManagedClusterAddonProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedClusterAddonProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _config = DefineDictionaryProperty<string>("Config", ["config"]);
        _identity = DefineModelProperty<ManagedClusterAddonProfileIdentity>("Identity", ["identity"], isOutput: true);
    }
}
