// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// For more details see [managed AAD on
/// AKS](https://docs.microsoft.com/azure/aks/managed-aad).
/// </summary>
public partial class ManagedClusterAadProfile : ProvisionableConstruct
{
    /// <summary>
    /// Whether to enable managed AAD.
    /// </summary>
    public BicepValue<bool> IsManagedAadEnabled 
    {
        get { Initialize(); return _isManagedAadEnabled!; }
        set { Initialize(); _isManagedAadEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isManagedAadEnabled;

    /// <summary>
    /// Whether to enable Azure RBAC for Kubernetes authorization.
    /// </summary>
    public BicepValue<bool> IsAzureRbacEnabled 
    {
        get { Initialize(); return _isAzureRbacEnabled!; }
        set { Initialize(); _isAzureRbacEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isAzureRbacEnabled;

    /// <summary>
    /// The list of AAD group object IDs that will have admin role of the
    /// cluster.
    /// </summary>
    public BicepList<Guid> AdminGroupObjectIds 
    {
        get { Initialize(); return _adminGroupObjectIds!; }
        set { Initialize(); _adminGroupObjectIds!.Assign(value); }
    }
    private BicepList<Guid>? _adminGroupObjectIds;

    /// <summary>
    /// (DEPRECATED) The client AAD application ID. Learn more at
    /// https://aka.ms/aks/aad-legacy.
    /// </summary>
    public BicepValue<Guid> ClientAppId 
    {
        get { Initialize(); return _clientAppId!; }
        set { Initialize(); _clientAppId!.Assign(value); }
    }
    private BicepValue<Guid>? _clientAppId;

    /// <summary>
    /// (DEPRECATED) The server AAD application ID. Learn more at
    /// https://aka.ms/aks/aad-legacy.
    /// </summary>
    public BicepValue<Guid> ServerAppId 
    {
        get { Initialize(); return _serverAppId!; }
        set { Initialize(); _serverAppId!.Assign(value); }
    }
    private BicepValue<Guid>? _serverAppId;

    /// <summary>
    /// (DEPRECATED) The server AAD application secret. Learn more at
    /// https://aka.ms/aks/aad-legacy.
    /// </summary>
    public BicepValue<string> ServerAppSecret 
    {
        get { Initialize(); return _serverAppSecret!; }
        set { Initialize(); _serverAppSecret!.Assign(value); }
    }
    private BicepValue<string>? _serverAppSecret;

    /// <summary>
    /// The AAD tenant ID to use for authentication. If not specified, will use
    /// the tenant of the deployment subscription.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Creates a new ManagedClusterAadProfile.
    /// </summary>
    public ManagedClusterAadProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagedClusterAadProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isManagedAadEnabled = DefineProperty<bool>("IsManagedAadEnabled", ["managed"]);
        _isAzureRbacEnabled = DefineProperty<bool>("IsAzureRbacEnabled", ["enableAzureRBAC"]);
        _adminGroupObjectIds = DefineListProperty<Guid>("AdminGroupObjectIds", ["adminGroupObjectIDs"]);
        _clientAppId = DefineProperty<Guid>("ClientAppId", ["clientAppID"]);
        _serverAppId = DefineProperty<Guid>("ServerAppId", ["serverAppID"]);
        _serverAppSecret = DefineProperty<string>("ServerAppSecret", ["serverAppSecret"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantID"]);
    }
}
