// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// See [AKS custom node
/// configuration](https://docs.microsoft.com/azure/aks/custom-node-configuration)
/// for more details.
/// </summary>
public partial class LinuxOSConfig : ProvisionableConstruct
{
    /// <summary>
    /// Sysctl settings for Linux agent nodes.
    /// </summary>
    public SysctlConfig Sysctls 
    {
        get { Initialize(); return _sysctls!; }
        set { Initialize(); AssignOrReplace(ref _sysctls, value); }
    }
    private SysctlConfig? _sysctls;

    /// <summary>
    /// Valid values are &apos;always&apos;, &apos;madvise&apos;, and
    /// &apos;never&apos;. The default is &apos;always&apos;. For more
    /// information see [Transparent
    /// Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
    /// </summary>
    public BicepValue<string> TransparentHugePageEnabled 
    {
        get { Initialize(); return _transparentHugePageEnabled!; }
        set { Initialize(); _transparentHugePageEnabled!.Assign(value); }
    }
    private BicepValue<string>? _transparentHugePageEnabled;

    /// <summary>
    /// Valid values are &apos;always&apos;, &apos;defer&apos;,
    /// &apos;defer+madvise&apos;, &apos;madvise&apos; and &apos;never&apos;.
    /// The default is &apos;madvise&apos;. For more information see
    /// [Transparent
    /// Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
    /// </summary>
    public BicepValue<string> TransparentHugePageDefrag 
    {
        get { Initialize(); return _transparentHugePageDefrag!; }
        set { Initialize(); _transparentHugePageDefrag!.Assign(value); }
    }
    private BicepValue<string>? _transparentHugePageDefrag;

    /// <summary>
    /// The size in MB of a swap file that will be created on each node.
    /// </summary>
    public BicepValue<int> SwapFileSizeInMB 
    {
        get { Initialize(); return _swapFileSizeInMB!; }
        set { Initialize(); _swapFileSizeInMB!.Assign(value); }
    }
    private BicepValue<int>? _swapFileSizeInMB;

    /// <summary>
    /// Creates a new LinuxOSConfig.
    /// </summary>
    public LinuxOSConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of LinuxOSConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _sysctls = DefineModelProperty<SysctlConfig>("Sysctls", ["sysctls"]);
        _transparentHugePageEnabled = DefineProperty<string>("TransparentHugePageEnabled", ["transparentHugePageEnabled"]);
        _transparentHugePageDefrag = DefineProperty<string>("TransparentHugePageDefrag", ["transparentHugePageDefrag"]);
        _swapFileSizeInMB = DefineProperty<int>("SwapFileSizeInMB", ["swapFileSizeMB"]);
    }
}
