// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Different support tiers for AKS managed clusters.
/// </summary>
public enum KubernetesSupportPlan
{
    /// <summary>
    /// Support for the version is the same as for the open source Kubernetes
    /// offering. Official Kubernetes open source community support versions
    /// for 1 year after release.
    /// </summary>
    KubernetesOfficial,

    /// <summary>
    /// Support for the version extended past the KubernetesOfficial support of
    /// 1 year. AKS continues to patch CVEs for another 1 year, for a total of
    /// 2 years of support.
    /// </summary>
    AKSLongTermSupport,
}
