// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// See [AKS custom node
/// configuration](https://docs.microsoft.com/azure/aks/custom-node-configuration)
/// for more details.
/// </summary>
public partial class KubeletConfig : ProvisionableConstruct
{
    /// <summary>
    /// The default is &apos;none&apos;. See [Kubernetes CPU management
    /// policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies)
    /// for more information. Allowed values are &apos;none&apos; and
    /// &apos;static&apos;.
    /// </summary>
    public BicepValue<string> CpuManagerPolicy 
    {
        get { Initialize(); return _cpuManagerPolicy!; }
        set { Initialize(); _cpuManagerPolicy!.Assign(value); }
    }
    private BicepValue<string>? _cpuManagerPolicy;

    /// <summary>
    /// The default is true.
    /// </summary>
    public BicepValue<bool> IsCpuCfsQuotaEnabled 
    {
        get { Initialize(); return _isCpuCfsQuotaEnabled!; }
        set { Initialize(); _isCpuCfsQuotaEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isCpuCfsQuotaEnabled;

    /// <summary>
    /// The default is &apos;100ms.&apos; Valid values are a sequence of
    /// decimal numbers with an optional fraction and a unit suffix. For
    /// example: &apos;300ms&apos;, &apos;2h45m&apos;. Supported units are
    /// &apos;ns&apos;, &apos;us&apos;, &apos;ms&apos;, &apos;s&apos;,
    /// &apos;m&apos;, and &apos;h&apos;.
    /// </summary>
    public BicepValue<string> CpuCfsQuotaPeriod 
    {
        get { Initialize(); return _cpuCfsQuotaPeriod!; }
        set { Initialize(); _cpuCfsQuotaPeriod!.Assign(value); }
    }
    private BicepValue<string>? _cpuCfsQuotaPeriod;

    /// <summary>
    /// To disable image garbage collection, set to 100. The default is 85%.
    /// </summary>
    public BicepValue<int> ImageGcHighThreshold 
    {
        get { Initialize(); return _imageGcHighThreshold!; }
        set { Initialize(); _imageGcHighThreshold!.Assign(value); }
    }
    private BicepValue<int>? _imageGcHighThreshold;

    /// <summary>
    /// This cannot be set higher than imageGcHighThreshold. The default is 80%.
    /// </summary>
    public BicepValue<int> ImageGcLowThreshold 
    {
        get { Initialize(); return _imageGcLowThreshold!; }
        set { Initialize(); _imageGcLowThreshold!.Assign(value); }
    }
    private BicepValue<int>? _imageGcLowThreshold;

    /// <summary>
    /// For more information see [Kubernetes Topology
    /// Manager](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager).
    /// The default is &apos;none&apos;. Allowed values are &apos;none&apos;,
    /// &apos;best-effort&apos;, &apos;restricted&apos;, and
    /// &apos;single-numa-node&apos;.
    /// </summary>
    public BicepValue<string> TopologyManagerPolicy 
    {
        get { Initialize(); return _topologyManagerPolicy!; }
        set { Initialize(); _topologyManagerPolicy!.Assign(value); }
    }
    private BicepValue<string>? _topologyManagerPolicy;

    /// <summary>
    /// Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in
    /// `*`).
    /// </summary>
    public BicepList<string> AllowedUnsafeSysctls 
    {
        get { Initialize(); return _allowedUnsafeSysctls!; }
        set { Initialize(); _allowedUnsafeSysctls!.Assign(value); }
    }
    private BicepList<string>? _allowedUnsafeSysctls;

    /// <summary>
    /// If set to true it will make the Kubelet fail to start if swap is
    /// enabled on the node.
    /// </summary>
    public BicepValue<bool> FailStartWithSwapOn 
    {
        get { Initialize(); return _failStartWithSwapOn!; }
        set { Initialize(); _failStartWithSwapOn!.Assign(value); }
    }
    private BicepValue<bool>? _failStartWithSwapOn;

    /// <summary>
    /// The maximum size (e.g. 10Mi) of container log file before it is rotated.
    /// </summary>
    public BicepValue<int> ContainerLogMaxSizeInMB 
    {
        get { Initialize(); return _containerLogMaxSizeInMB!; }
        set { Initialize(); _containerLogMaxSizeInMB!.Assign(value); }
    }
    private BicepValue<int>? _containerLogMaxSizeInMB;

    /// <summary>
    /// The maximum number of container log files that can be present for a
    /// container. The number must be ≥ 2.
    /// </summary>
    public BicepValue<int> ContainerLogMaxFiles 
    {
        get { Initialize(); return _containerLogMaxFiles!; }
        set { Initialize(); _containerLogMaxFiles!.Assign(value); }
    }
    private BicepValue<int>? _containerLogMaxFiles;

    /// <summary>
    /// The maximum number of processes per pod.
    /// </summary>
    public BicepValue<int> PodMaxPids 
    {
        get { Initialize(); return _podMaxPids!; }
        set { Initialize(); _podMaxPids!.Assign(value); }
    }
    private BicepValue<int>? _podMaxPids;

    /// <summary>
    /// Creates a new KubeletConfig.
    /// </summary>
    public KubeletConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KubeletConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _cpuManagerPolicy = DefineProperty<string>("CpuManagerPolicy", ["cpuManagerPolicy"]);
        _isCpuCfsQuotaEnabled = DefineProperty<bool>("IsCpuCfsQuotaEnabled", ["cpuCfsQuota"]);
        _cpuCfsQuotaPeriod = DefineProperty<string>("CpuCfsQuotaPeriod", ["cpuCfsQuotaPeriod"]);
        _imageGcHighThreshold = DefineProperty<int>("ImageGcHighThreshold", ["imageGcHighThreshold"]);
        _imageGcLowThreshold = DefineProperty<int>("ImageGcLowThreshold", ["imageGcLowThreshold"]);
        _topologyManagerPolicy = DefineProperty<string>("TopologyManagerPolicy", ["topologyManagerPolicy"]);
        _allowedUnsafeSysctls = DefineListProperty<string>("AllowedUnsafeSysctls", ["allowedUnsafeSysctls"]);
        _failStartWithSwapOn = DefineProperty<bool>("FailStartWithSwapOn", ["failSwapOn"]);
        _containerLogMaxSizeInMB = DefineProperty<int>("ContainerLogMaxSizeInMB", ["containerLogMaxSizeMB"]);
        _containerLogMaxFiles = DefineProperty<int>("ContainerLogMaxFiles", ["containerLogMaxFiles"]);
        _podMaxPids = DefineProperty<int>("PodMaxPids", ["podMaxPids"]);
    }
}
