// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Istio service mesh configuration.
/// </summary>
public partial class IstioServiceMesh : ProvisionableConstruct
{
    /// <summary>
    /// Istio components configuration.
    /// </summary>
    public IstioComponents Components 
    {
        get { Initialize(); return _components!; }
        set { Initialize(); AssignOrReplace(ref _components, value); }
    }
    private IstioComponents? _components;

    /// <summary>
    /// Plugin certificates information for Service Mesh.
    /// </summary>
    public IstioPluginCertificateAuthority CertificateAuthorityPlugin 
    {
        get { Initialize(); return _certificateAuthorityPlugin!; }
        set { Initialize(); AssignOrReplace(ref _certificateAuthorityPlugin, value); }
    }
    private IstioPluginCertificateAuthority? _certificateAuthorityPlugin;

    /// <summary>
    /// The list of revisions of the Istio control plane. When an upgrade is
    /// not in progress, this holds one value. When canary upgrade is in
    /// progress, this can only hold two consecutive values. For more
    /// information, see:
    /// https://learn.microsoft.com/en-us/azure/aks/istio-upgrade.
    /// </summary>
    public BicepList<string> Revisions 
    {
        get { Initialize(); return _revisions!; }
        set { Initialize(); _revisions!.Assign(value); }
    }
    private BicepList<string>? _revisions;

    /// <summary>
    /// Creates a new IstioServiceMesh.
    /// </summary>
    public IstioServiceMesh()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of IstioServiceMesh.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _components = DefineModelProperty<IstioComponents>("Components", ["components"]);
        _certificateAuthorityPlugin = DefineModelProperty<IstioPluginCertificateAuthority>("CertificateAuthorityPlugin", ["certificateAuthority", "plugin"]);
        _revisions = DefineListProperty<string>("Revisions", ["revisions"]);
    }
}
