// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Plugin certificates information for Service Mesh.
/// </summary>
public partial class IstioPluginCertificateAuthority : ProvisionableConstruct
{
    /// <summary>
    /// The resource ID of the Key Vault.
    /// </summary>
    public BicepValue<ResourceIdentifier> KeyVaultId 
    {
        get { Initialize(); return _keyVaultId!; }
        set { Initialize(); _keyVaultId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _keyVaultId;

    /// <summary>
    /// Intermediate certificate object name in Azure Key Vault.
    /// </summary>
    public BicepValue<string> CertObjectName 
    {
        get { Initialize(); return _certObjectName!; }
        set { Initialize(); _certObjectName!.Assign(value); }
    }
    private BicepValue<string>? _certObjectName;

    /// <summary>
    /// Intermediate certificate private key object name in Azure Key Vault.
    /// </summary>
    public BicepValue<string> KeyObjectName 
    {
        get { Initialize(); return _keyObjectName!; }
        set { Initialize(); _keyObjectName!.Assign(value); }
    }
    private BicepValue<string>? _keyObjectName;

    /// <summary>
    /// Root certificate object name in Azure Key Vault.
    /// </summary>
    public BicepValue<string> RootCertObjectName 
    {
        get { Initialize(); return _rootCertObjectName!; }
        set { Initialize(); _rootCertObjectName!.Assign(value); }
    }
    private BicepValue<string>? _rootCertObjectName;

    /// <summary>
    /// Certificate chain object name in Azure Key Vault.
    /// </summary>
    public BicepValue<string> CertChainObjectName 
    {
        get { Initialize(); return _certChainObjectName!; }
        set { Initialize(); _certChainObjectName!.Assign(value); }
    }
    private BicepValue<string>? _certChainObjectName;

    /// <summary>
    /// Creates a new IstioPluginCertificateAuthority.
    /// </summary>
    public IstioPluginCertificateAuthority()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// IstioPluginCertificateAuthority.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keyVaultId = DefineProperty<ResourceIdentifier>("KeyVaultId", ["keyVaultId"]);
        _certObjectName = DefineProperty<string>("CertObjectName", ["certObjectName"]);
        _keyObjectName = DefineProperty<string>("KeyObjectName", ["keyObjectName"]);
        _rootCertObjectName = DefineProperty<string>("RootCertObjectName", ["rootCertObjectName"]);
        _certChainObjectName = DefineProperty<string>("CertChainObjectName", ["certChainObjectName"]);
    }
}
