// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Istio ingress gateway configuration. For now, we support up to one external
/// ingress gateway named `aks-istio-ingressgateway-external` and one internal
/// ingress gateway named `aks-istio-ingressgateway-internal`.
/// </summary>
public partial class IstioIngressGateway : ProvisionableConstruct
{
    /// <summary>
    /// Mode of an ingress gateway.
    /// </summary>
    public BicepValue<IstioIngressGatewayMode> Mode 
    {
        get { Initialize(); return _mode!; }
        set { Initialize(); _mode!.Assign(value); }
    }
    private BicepValue<IstioIngressGatewayMode>? _mode;

    /// <summary>
    /// Whether to enable the ingress gateway.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Creates a new IstioIngressGateway.
    /// </summary>
    public IstioIngressGateway()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of IstioIngressGateway.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _mode = DefineProperty<IstioIngressGatewayMode>("Mode", ["mode"]);
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
    }
}
