// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Istio egress gateway configuration.
/// </summary>
public partial class IstioEgressGateway : ProvisionableConstruct
{
    /// <summary>
    /// Whether to enable the egress gateway.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// NodeSelector for scheduling the egress gateway.
    /// </summary>
    public BicepDictionary<string> NodeSelector 
    {
        get { Initialize(); return _nodeSelector!; }
        set { Initialize(); _nodeSelector!.Assign(value); }
    }
    private BicepDictionary<string>? _nodeSelector;

    /// <summary>
    /// Creates a new IstioEgressGateway.
    /// </summary>
    public IstioEgressGateway()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of IstioEgressGateway.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _nodeSelector = DefineDictionaryProperty<string>("NodeSelector", ["nodeSelector"]);
    }
}
