// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Details about a user assigned identity.
/// </summary>
public partial class ContainerServiceUserAssignedIdentity : ProvisionableConstruct
{
    /// <summary>
    /// The resource ID of the user assigned identity.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
        set { Initialize(); _resourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// The client ID of the user assigned identity.
    /// </summary>
    public BicepValue<Guid> ClientId 
    {
        get { Initialize(); return _clientId!; }
        set { Initialize(); _clientId!.Assign(value); }
    }
    private BicepValue<Guid>? _clientId;

    /// <summary>
    /// The object ID of the user assigned identity.
    /// </summary>
    public BicepValue<Guid> ObjectId 
    {
        get { Initialize(); return _objectId!; }
        set { Initialize(); _objectId!.Assign(value); }
    }
    private BicepValue<Guid>? _objectId;

    /// <summary>
    /// Creates a new ContainerServiceUserAssignedIdentity.
    /// </summary>
    public ContainerServiceUserAssignedIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerServiceUserAssignedIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["resourceId"]);
        _clientId = DefineProperty<Guid>("ClientId", ["clientId"]);
        _objectId = DefineProperty<Guid>("ObjectId", ["objectId"]);
    }
}
