// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.
/// </summary>
public partial class ContainerServiceTimeSpan : ProvisionableConstruct
{
    /// <summary>
    /// The start of a time span.
    /// </summary>
    public BicepValue<DateTimeOffset> StartOn 
    {
        get { Initialize(); return _startOn!; }
        set { Initialize(); _startOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _startOn;

    /// <summary>
    /// The end of a time span.
    /// </summary>
    public BicepValue<DateTimeOffset> EndOn 
    {
        get { Initialize(); return _endOn!; }
        set { Initialize(); _endOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _endOn;

    /// <summary>
    /// Creates a new ContainerServiceTimeSpan.
    /// </summary>
    public ContainerServiceTimeSpan()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerServiceTimeSpan.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _startOn = DefineProperty<DateTimeOffset>("StartOn", ["start"]);
        _endOn = DefineProperty<DateTimeOffset>("EndOn", ["end"]);
    }
}
