// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Time in a week.
/// </summary>
public partial class ContainerServiceTimeInWeek : ProvisionableConstruct
{
    /// <summary>
    /// The day of the week.
    /// </summary>
    public BicepValue<ContainerServiceWeekDay> Day 
    {
        get { Initialize(); return _day!; }
        set { Initialize(); _day!.Assign(value); }
    }
    private BicepValue<ContainerServiceWeekDay>? _day;

    /// <summary>
    /// Each integer hour represents a time range beginning at 0m after the
    /// hour ending at the next hour (non-inclusive). 0 corresponds to 00:00
    /// UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 -
    /// 02:00 UTC time range.
    /// </summary>
    public BicepList<int> HourSlots 
    {
        get { Initialize(); return _hourSlots!; }
        set { Initialize(); _hourSlots!.Assign(value); }
    }
    private BicepList<int>? _hourSlots;

    /// <summary>
    /// Creates a new ContainerServiceTimeInWeek.
    /// </summary>
    public ContainerServiceTimeInWeek()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerServiceTimeInWeek.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _day = DefineProperty<ContainerServiceWeekDay>("Day", ["day"]);
        _hourSlots = DefineListProperty<int>("HourSlots", ["hourSlots"]);
    }
}
