// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Contains information about SSH certificate public key data.
/// </summary>
public partial class ContainerServiceSshPublicKey : ProvisionableConstruct
{
    /// <summary>
    /// Certificate public key used to authenticate with VMs through SSH. The
    /// certificate must be in PEM format with or without headers.
    /// </summary>
    public BicepValue<string> KeyData 
    {
        get { Initialize(); return _keyData!; }
        set { Initialize(); _keyData!.Assign(value); }
    }
    private BicepValue<string>? _keyData;

    /// <summary>
    /// Creates a new ContainerServiceSshPublicKey.
    /// </summary>
    public ContainerServiceSshPublicKey()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerServiceSshPublicKey.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keyData = DefineProperty<string>("KeyData", ["keyData"]);
    }
}
