// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// The state of a private link service connection.
/// </summary>
public partial class ContainerServicePrivateLinkServiceConnectionState : ProvisionableConstruct
{
    /// <summary>
    /// The private link service connection status.
    /// </summary>
    public BicepValue<ContainerServicePrivateLinkServiceConnectionStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<ContainerServicePrivateLinkServiceConnectionStatus>? _status;

    /// <summary>
    /// The private link service connection description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Creates a new ContainerServicePrivateLinkServiceConnectionState.
    /// </summary>
    public ContainerServicePrivateLinkServiceConnectionState()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerServicePrivateLinkServiceConnectionState.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<ContainerServicePrivateLinkServiceConnectionStatus>("Status", ["status"]);
        _description = DefineProperty<string>("Description", ["description"]);
    }
}
