// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// A private link resource.
/// </summary>
public partial class ContainerServicePrivateLinkResourceData : ProvisionableConstruct
{
    /// <summary>
    /// The ID of the private link resource.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The name of the private link resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The resource type.
    /// </summary>
    public BicepValue<ResourceType> ResourceType 
    {
        get { Initialize(); return _resourceType!; }
        set { Initialize(); _resourceType!.Assign(value); }
    }
    private BicepValue<ResourceType>? _resourceType;

    /// <summary>
    /// The group ID of the resource.
    /// </summary>
    public BicepValue<string> GroupId 
    {
        get { Initialize(); return _groupId!; }
        set { Initialize(); _groupId!.Assign(value); }
    }
    private BicepValue<string>? _groupId;

    /// <summary>
    /// The RequiredMembers of the resource.
    /// </summary>
    public BicepList<string> RequiredMembers 
    {
        get { Initialize(); return _requiredMembers!; }
        set { Initialize(); _requiredMembers!.Assign(value); }
    }
    private BicepList<string>? _requiredMembers;

    /// <summary>
    /// The private link service ID of the resource, this field is exposed only
    /// to NRP internally.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateLinkServiceId 
    {
        get { Initialize(); return _privateLinkServiceId!; }
    }
    private BicepValue<ResourceIdentifier>? _privateLinkServiceId;

    /// <summary>
    /// Creates a new ContainerServicePrivateLinkResourceData.
    /// </summary>
    public ContainerServicePrivateLinkResourceData()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerServicePrivateLinkResourceData.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"]);
        _name = DefineProperty<string>("Name", ["name"]);
        _resourceType = DefineProperty<ResourceType>("ResourceType", ["type"]);
        _groupId = DefineProperty<string>("GroupId", ["groupId"]);
        _requiredMembers = DefineListProperty<string>("RequiredMembers", ["requiredMembers"]);
        _privateLinkServiceId = DefineProperty<ResourceIdentifier>("PrivateLinkServiceId", ["privateLinkServiceID"], isOutput: true);
    }
}
