// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.Runtime.Serialization;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// This can only be set at cluster creation time and cannot be changed later.
/// For more information see [egress outbound
/// type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
/// </summary>
public enum ContainerServiceOutboundType
{
    /// <summary>
    /// The load balancer is used for egress through an AKS assigned public IP.
    /// This supports Kubernetes services of type &apos;loadBalancer&apos;.
    /// For more information see [outbound type
    /// loadbalancer](https://docs.microsoft.com/azure/aks/egress-outboundtype#outbound-type-of-loadbalancer).
    /// </summary>
    [DataMember(Name = "loadBalancer")]
    LoadBalancer,

    /// <summary>
    /// Egress paths must be defined by the user. This is an advanced scenario
    /// and requires proper network configuration. For more information see
    /// [outbound type
    /// userDefinedRouting](https://docs.microsoft.com/azure/aks/egress-outboundtype#outbound-type-of-userdefinedrouting).
    /// </summary>
    [DataMember(Name = "userDefinedRouting")]
    UserDefinedRouting,

    /// <summary>
    /// The AKS-managed NAT gateway is used for egress.
    /// </summary>
    [DataMember(Name = "managedNATGateway")]
    ManagedNatGateway,

    /// <summary>
    /// The user-assigned NAT gateway associated to the cluster subnet is used
    /// for egress. This is an advanced scenario and requires proper network
    /// configuration.
    /// </summary>
    [DataMember(Name = "userAssignedNATGateway")]
    UserAssignedNatGateway,
}
