// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.Runtime.Serialization;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Specifies the OS SKU used by the agent pool. The default is Ubuntu if
/// OSType is Linux. The default is Windows2019 when Kubernetes &lt;= 1.24 or
/// Windows2022 when Kubernetes &gt;= 1.25 if OSType is Windows.
/// </summary>
public enum ContainerServiceOSSku
{
    /// <summary>
    /// Use Ubuntu as the OS for node images.
    /// </summary>
    Ubuntu,

    /// <summary>
    /// Use AzureLinux as the OS for node images. Azure Linux is a
    /// container-optimized Linux distro built by Microsoft, visit
    /// https://aka.ms/azurelinux for more information.
    /// </summary>
    AzureLinux,

    /// <summary>
    /// Deprecated OSSKU. Microsoft recommends that new deployments choose
    /// &apos;AzureLinux&apos; instead.
    /// </summary>
    [DataMember(Name = "CBLMariner")]
    CblMariner,

    /// <summary>
    /// Use Windows2019 as the OS for node images. Unsupported for system node
    /// pools. Windows2019 only supports Windows2019 containers; it cannot run
    /// Windows2022 containers and vice versa.
    /// </summary>
    Windows2019,

    /// <summary>
    /// Use Windows2022 as the OS for node images. Unsupported for system node
    /// pools. Windows2022 only supports Windows2022 containers; it cannot run
    /// Windows2019 containers and vice versa.
    /// </summary>
    Windows2022,
}
