// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// The default is &apos;Ephemeral&apos; if the VM supports it and has a cache
/// disk larger than the requested OSDiskSizeGB. Otherwise, defaults to
/// &apos;Managed&apos;. May not be changed after creation. For more
/// information see [Ephemeral
/// OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
/// </summary>
public enum ContainerServiceOSDiskType
{
    /// <summary>
    /// Azure replicates the operating system disk for a virtual machine to
    /// Azure storage to avoid data loss should the VM need to be relocated to
    /// another host. Since containers aren&apos;t designed to have local
    /// state persisted, this behavior offers limited value while providing
    /// some drawbacks, including slower node provisioning and higher
    /// read/write latency.
    /// </summary>
    Managed,

    /// <summary>
    /// Ephemeral OS disks are stored only on the host machine, just like a
    /// temporary disk. This provides lower read/write latency, along with
    /// faster node scaling and cluster upgrades.
    /// </summary>
    Ephemeral,
}
