// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.Runtime.Serialization;

namespace Azure.Provisioning.ContainerService;

/// <summary>
/// Network policy used for building the Kubernetes network.
/// </summary>
public enum ContainerServiceNetworkPolicy
{
    /// <summary>
    /// Use Calico network policies. See [differences between Azure and Calico
    /// policies](https://docs.microsoft.com/azure/aks/use-network-policies#differences-between-azure-and-calico-policies-and-their-capabilities)
    /// for more information.
    /// </summary>
    [DataMember(Name = "calico")]
    Calico,

    /// <summary>
    /// Use Azure network policies. See [differences between Azure and Calico
    /// policies](https://docs.microsoft.com/azure/aks/use-network-policies#differences-between-azure-and-calico-policies-and-their-capabilities)
    /// for more information.
    /// </summary>
    [DataMember(Name = "azure")]
    Azure,

    /// <summary>
    /// Use Cilium to enforce network policies. This requires networkDataplane
    /// to be &apos;cilium&apos;.
    /// </summary>
    [DataMember(Name = "cilium")]
    Cilium,
}
